/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.transactions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class ScheduledPaymentQuery
extends QueryParameters {
    private static final long serialVersionUID = -8537384458915898501L;
    private AccountOwner owner;
    private AccountType accountType;
    private Member member;
    private Period period;
    private StatusGroup statusGroup;
    private Collection<Payment.Status> statusList;
    private SearchType searchType;

    public AccountType getAccountType() {
        return this.accountType;
    }

    public Member getMember() {
        return this.member;
    }

    public AccountOwner getOwner() {
        return this.owner;
    }

    public Period getPeriod() {
        return this.period;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public StatusGroup getStatusGroup() {
        return this.statusGroup;
    }

    public Collection<Payment.Status> getStatusList() {
        return this.statusList;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public void setOwner(AccountOwner owner) {
        this.owner = owner;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
    }

    public void setStatus(Payment.Status status) {
        this.statusList = Collections.singletonList(status);
    }

    public void setStatusGroup(StatusGroup statusGroup) {
        this.statusGroup = statusGroup;
        this.statusList = statusGroup == null ? null : statusGroup.getStatusList();
    }

    public void setStatusList(Collection<Payment.Status> statusList) {
        this.statusList = statusList;
    }

    public static enum StatusGroup {
        OPEN,
        CLOSED_WITHOUT_ERRORS,
        CLOSED_WITH_ERRORS;


        public List<Payment.Status> getStatusList() {
            switch (this) {
                case OPEN: {
                    return Arrays.asList(Payment.Status.SCHEDULED, Payment.Status.PENDING, Payment.Status.BLOCKED, Payment.Status.FAILED);
                }
                case CLOSED_WITHOUT_ERRORS: {
                    return Arrays.asList(Payment.Status.PROCESSED);
                }
            }
            return Arrays.asList(Payment.Status.CANCELED, Payment.Status.DENIED);
        }
    }

    public static enum SearchType {
        OUTGOING,
        INCOMING;

    }
}

