/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.transactions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public abstract class Ticket
extends Entity {
    private static final long serialVersionUID = -4036600783513490404L;
    private BigDecimal amount;
    private Currency currency;
    private Calendar creationDate;
    private String description;
    private Member from;
    private Status status;
    private String ticket;
    private Member to;
    private Transfer transfer;
    private TransferType transferType;

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public Member getFrom() {
        return this.from;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getTicket() {
        return this.ticket;
    }

    public Member getTo() {
        return this.to;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFrom(Member from) {
        this.from = from;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public void setTo(Member to) {
        this.to = to;
    }

    public void setTransfer(Transfer transfer) {
        this.transfer = transfer;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    @Override
    public String toString() {
        return "Ticket [id=" + this.getId() + ", ticket=" + this.ticket + "]";
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        variables.put("amount", localSettings.getUnitsConverter(this.getCurrency().getPattern()).toString(this.getAmount()));
        variables.put("date", localSettings.getDateConverter().toString(this.creationDate));
        variables.put("from_member", this.from.getName());
        variables.put("from_login", this.from.getUsername());
        variables.put("to_member", this.to.getName());
        variables.put("to_login", this.to.getUsername());
    }

    public static enum Status implements StringValuedEnum
    {
        CANCELLED("C"),
        EXPIRED("E"),
        OK("O"),
        PENDING("P"),
        FAILED("F");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        CURRENCY("currency"),
        FROM("from"),
        TO("to"),
        TRANSFER_TYPE("transferType"),
        TRANSFER("transfer");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Nature implements StringValuedEnum
    {
        WEBSHOP("W"),
        PAYMENT_REQUEST("R");

        private final String value;

        private Nature(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

