/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.transactions;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.Rated;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.external.ExternalTransfer;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFeeLog;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorization;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import org.apache.commons.lang.ObjectUtils;

public class Transfer
extends Payment
implements Rated {
    private static final long serialVersionUID = -4749387454425166686L;
    private AccountFeeLog accountFeeLog;
    private Collection<Transfer> children;
    private Transfer chargedBackBy;
    private String transactionNumber;
    private String traceNumber;
    private Long clientId;
    private String traceData;
    private LoanPayment loanPayment;
    private Transfer parent;
    private Transfer chargebackOf;
    private TransactionFee transactionFee;
    private Element receiver;
    private ExternalTransfer externalTransfer;
    private Collection<TransferAuthorization> authorizations;
    private AuthorizationLevel nextAuthorizationLevel;
    private ScheduledPayment scheduledPayment;
    private BrokerCommissionContract brokerCommissionContract;
    private Calendar expirationDate;
    private Calendar emissionDate;
    private BigDecimal iRate;
    private transient Transfer root;

    public AccountFeeLog getAccountFeeLog() {
        return this.accountFeeLog;
    }

    @Override
    public BigDecimal getActualAmount() {
        BigDecimal amount = this.getAmount();
        return amount == null ? null : amount.abs();
    }

    @Override
    public Calendar getActualDate() {
        return this.getProcessDate() == null ? this.getDate() : this.getProcessDate();
    }

    @Override
    public Account getActualFrom() {
        BigDecimal amount = this.getAmount();
        return amount == null || amount.compareTo(BigDecimal.ZERO) >= 0 ? this.getFrom() : this.getTo();
    }

    @Override
    public AccountOwner getActualFromOwner() {
        return this.getActualFrom().getOwner();
    }

    @Override
    public Account getActualTo() {
        BigDecimal amount = this.getAmount();
        return amount == null || amount.compareTo(BigDecimal.ZERO) >= 0 ? this.getTo() : this.getFrom();
    }

    @Override
    public AccountOwner getActualToOwner() {
        return this.getActualTo().getOwner();
    }

    public Collection<TransferAuthorization> getAuthorizations() {
        return this.authorizations;
    }

    public BrokerCommissionContract getBrokerCommissionContract() {
        return this.brokerCommissionContract;
    }

    public Transfer getChargebackOf() {
        return this.chargebackOf;
    }

    public Transfer getChargedBackBy() {
        return this.chargedBackBy;
    }

    public Collection<Transfer> getChildren() {
        return this.children;
    }

    public Long getClientId() {
        return this.clientId;
    }

    @Override
    public Calendar getEmissionDate() {
        return this.emissionDate;
    }

    @Override
    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public ExternalTransfer getExternalTransfer() {
        return this.externalTransfer;
    }

    @Override
    public BigDecimal getiRate() {
        return this.iRate;
    }

    public LoanPayment getLoanPayment() {
        return this.loanPayment;
    }

    @Override
    public Payment.Nature getNature() {
        return Payment.Nature.TRANSFER;
    }

    public AuthorizationLevel getNextAuthorizationLevel() {
        return this.nextAuthorizationLevel;
    }

    public Transfer getParent() {
        return this.parent;
    }

    public Element getReceiver() {
        return this.receiver;
    }

    public Transfer getRootTransfer() {
        if (this.root == null) {
            Transfer topMost = this;
            while (topMost.getParent() != null) {
                topMost = topMost.getParent();
            }
            this.root = topMost;
        }
        return this.root;
    }

    public ScheduledPayment getScheduledPayment() {
        return this.scheduledPayment;
    }

    public String getTraceData() {
        return this.traceData;
    }

    public String getTraceNumber() {
        return this.traceNumber;
    }

    public TransactionFee getTransactionFee() {
        return this.transactionFee;
    }

    public String getTransactionNumber() {
        return this.transactionNumber;
    }

    public boolean isActuallyFromSystem() {
        return this.getActualFromOwner() instanceof SystemAccountOwner;
    }

    public boolean isActuallyToSystem() {
        return this.getActualToOwner() instanceof SystemAccountOwner;
    }

    public boolean isProcessedAtDifferentDate() {
        return !ObjectUtils.equals((Object)this.getDate(), (Object)this.getProcessDate());
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setAccountFeeLog(AccountFeeLog feeLog) {
        this.accountFeeLog = feeLog;
    }

    public void setAuthorizations(Collection<TransferAuthorization> authorizations) {
        this.authorizations = authorizations;
    }

    public void setBrokerCommissionContract(BrokerCommissionContract brokerCommissionContract) {
        this.brokerCommissionContract = brokerCommissionContract;
    }

    public void setChargebackOf(Transfer chargebackOf) {
        this.chargebackOf = chargebackOf;
    }

    public void setChargedBackBy(Transfer chargedBackBy) {
        this.chargedBackBy = chargedBackBy;
    }

    public void setChildren(Collection<Transfer> children) {
        this.children = children;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public void setEmissionDate(Calendar emissionDate) {
        this.emissionDate = emissionDate;
    }

    public void setExpirationDate(Calendar expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setExternalTransfer(ExternalTransfer externalTransfer) {
        this.externalTransfer = externalTransfer;
    }

    public void setiRate(BigDecimal iRate) {
        this.iRate = iRate;
    }

    public void setLoanPayment(LoanPayment loanComponent) {
        this.loanPayment = loanComponent;
    }

    public void setNextAuthorizationLevel(AuthorizationLevel nextAuthorizationLevel) {
        this.nextAuthorizationLevel = nextAuthorizationLevel;
    }

    public void setParent(Transfer parent) {
        this.parent = parent;
        this.root = null;
    }

    public void setReceiver(Element receiver) {
        this.receiver = receiver;
    }

    public void setScheduledPayment(ScheduledPayment scheduledPayment) {
        this.scheduledPayment = scheduledPayment;
    }

    public void setTraceData(String traceData) {
        this.traceData = traceData;
    }

    public void setTraceNumber(String traceNumber) {
        this.traceNumber = traceNumber;
    }

    public void setTransactionFee(TransactionFee fee) {
        this.transactionFee = fee;
    }

    public void setTransactionNumber(String transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        super.appendVariableValues(variables, localSettings);
        variables.put("transaction_number", this.getTransactionNumber());
    }

    public static enum Relationships implements Relationship
    {
        ACCOUNT_FEE_LOG("accountFeeLog"),
        CHILDREN("children"),
        CHARGED_BACK_BY("chargedBackBy"),
        LOAN_PAYMENT("loanPayment"),
        PARENT("parent"),
        CHARGEBACK_OF("chargebackOf"),
        TRANSACTION_FEE("transactionFee"),
        RECEIVER("receiver"),
        EXTERNAL_TRANSFER("externalTransfer"),
        AUTHORIZATIONS("authorizations"),
        NEXT_AUTHORIZATION_LEVEL("nextAuthorizationLevel"),
        SCHEDULED_PAYMENT("scheduledPayment");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

