/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.transactions;

import java.util.Collection;
import java.util.Collections;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.loans.LoanPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;

public class TransferQuery
extends QueryParameters {
    private static final long serialVersionUID = 2190013517134381440L;
    private String description;
    private LoanPayment loanPayment;
    private Member member;
    private Collection<MemberGroup> groups;
    private Collection<GroupFilter> groupFilters;
    private Element by;
    private AccountOwner owner;
    private AccountOwner fromAccountOwner;
    private AccountOwner toAccountOwner;
    private Transfer parent;
    private Collection<PaymentFilter> paymentFilters;
    private TransferType transferType;
    private TransferType excludeTransferType;
    private Period period;
    private AccountType type;
    private AccountType fromAccountType;
    private AccountType toAccountType;
    private String transactionNumber;
    private boolean reverseOrder;
    private Boolean conciliated;
    private boolean rootOnly;
    private Payment.Status status = Payment.Status.PROCESSED;
    private Boolean requiresAuthorization;
    private boolean unordered;
    private Collection<PaymentCustomFieldValue> customValues;
    private Boolean loanTransfer;

    public Element getBy() {
        return this.by;
    }

    public Boolean getConciliated() {
        return this.conciliated;
    }

    public Collection<PaymentCustomFieldValue> getCustomValues() {
        return this.customValues;
    }

    public String getDescription() {
        return this.description;
    }

    public TransferType getExcludeTransferType() {
        return this.excludeTransferType;
    }

    public AccountOwner getFromAccountOwner() {
        return this.fromAccountOwner;
    }

    public AccountType getFromAccountType() {
        return this.fromAccountType;
    }

    public Collection<GroupFilter> getGroupFilters() {
        return this.groupFilters;
    }

    public Collection<MemberGroup> getGroups() {
        return this.groups;
    }

    public LoanPayment getLoanPayment() {
        return this.loanPayment;
    }

    public Boolean getLoanTransfer() {
        return this.loanTransfer;
    }

    public Member getMember() {
        return this.member;
    }

    public AccountOwner getOwner() {
        return this.owner;
    }

    public Transfer getParent() {
        return this.parent;
    }

    public PaymentFilter getPaymentFilter() {
        return CollectionUtils.isEmpty(this.paymentFilters) ? null : this.paymentFilters.iterator().next();
    }

    public Collection<PaymentFilter> getPaymentFilters() {
        return this.paymentFilters;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Boolean getRequiresAuthorization() {
        return this.requiresAuthorization;
    }

    public Payment.Status getStatus() {
        return this.status;
    }

    public AccountOwner getToAccountOwner() {
        return this.toAccountOwner;
    }

    public AccountType getToAccountType() {
        return this.toAccountType;
    }

    public String getTransactionNumber() {
        return this.transactionNumber;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public AccountType getType() {
        return this.type;
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public boolean isRootOnly() {
        return this.rootOnly;
    }

    public boolean isUnordered() {
        return this.unordered;
    }

    public void setBy(Element by) {
        this.by = by;
    }

    public void setConciliated(Boolean conciliated) {
        this.conciliated = conciliated;
    }

    public void setCustomValues(Collection<PaymentCustomFieldValue> customValues) {
        this.customValues = customValues;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExcludeTransferType(TransferType excludeTransferType) {
        this.excludeTransferType = excludeTransferType;
    }

    public void setFromAccountOwner(AccountOwner fromAccountOwner) {
        this.fromAccountOwner = fromAccountOwner;
    }

    public void setFromAccountType(AccountType fromAccountType) {
        this.fromAccountType = fromAccountType;
    }

    public void setGroupFilters(Collection<GroupFilter> groupFilters) {
        this.groupFilters = groupFilters;
    }

    public void setGroups(Collection<MemberGroup> groups) {
        this.groups = groups;
    }

    public void setLoanPayment(LoanPayment loanPayment) {
        this.loanPayment = loanPayment;
    }

    public void setLoanTransfer(Boolean loanTransfer) {
        this.loanTransfer = loanTransfer;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public void setOwner(AccountOwner owner) {
        this.owner = owner;
    }

    public void setParent(Transfer parent) {
        this.parent = parent;
    }

    public void setPaymentFilter(PaymentFilter paymentFilter) {
        this.paymentFilters = paymentFilter == null ? null : Collections.singletonList(paymentFilter);
    }

    public void setPaymentFilters(Collection<PaymentFilter> paymentFilters) {
        this.paymentFilters = paymentFilters;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public void setRequiresAuthorization(Boolean requiresAuthorization) {
        this.requiresAuthorization = requiresAuthorization;
    }

    public void setReverseOrder(boolean reverseOrder) {
        this.reverseOrder = reverseOrder;
    }

    public void setRootOnly(boolean rootOnly) {
        this.rootOnly = rootOnly;
    }

    public void setStatus(Payment.Status status) {
        this.status = status;
    }

    public void setToAccountOwner(AccountOwner toAccountOwner) {
        this.toAccountOwner = toAccountOwner;
    }

    public void setToAccountType(AccountType toAccountType) {
        this.toAccountType = toAccountType;
    }

    public void setTransactionNumber(String transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public void setType(AccountType type) {
        this.type = type;
    }

    public void setUnordered(boolean unordered) {
        this.unordered = unordered;
    }
}

