/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.accounts.transactions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.loans.LoanParameters;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.TimePeriod;
import org.apache.commons.collections.CollectionUtils;

public class TransferType
extends Entity {
    private static final long serialVersionUID = -6248433842449336187L;
    private String name;
    private String description;
    private String confirmationMessage;
    private Context context = new Context();
    private boolean priority;
    private boolean conciliable;
    private AccountType from;
    private AccountType to;
    private BigDecimal maxAmountPerDay;
    private BigDecimal minAmount;
    private LoanParameters loan;
    private Collection<? extends TransactionFee> transactionFees;
    private Collection<? extends TransactionFee> generatedByTransactionFees;
    private Collection<? extends AccountFee> generatedByAccountFees;
    private Collection<? extends Group> groups;
    private Collection<? extends Group> groupsAsMember;
    private Collection<PaymentFilter> paymentFilters;
    private boolean requiresAuthorization;
    private Collection<AuthorizationLevel> authorizationLevels;
    private boolean allowsScheduledPayments;
    private boolean requiresFeedback;
    private boolean reserveTotalAmountOnScheduling;
    private boolean allowCancelScheduledPayments;
    private boolean allowBlockScheduledPayments;
    private boolean showScheduledPaymentsToDestination;
    private boolean allowSmsNotification;
    private Calendar feedbackEnabledSince;
    private TimePeriod feedbackExpirationTime;
    private TimePeriod feedbackReplyExpirationTime;
    private String defaultFeedbackComments;
    private Reference.Level defaultFeedbackLevel;
    private Collection<Channel> channels;
    private Member fixedDestinationMember;
    private Collection<PaymentCustomField> customFields;
    private Collection<PaymentCustomField> linkedCustomFields;
    private String transferListenerClass;
    private TransactionHierarchyVisibility transactionHierarchyVisibility = TransactionHierarchyVisibility.MEMBER;

    public Collection<? extends TransactionFee> getARatedFees() {
        ArrayList<TransactionFee> result = new ArrayList<TransactionFee>(this.transactionFees.size());
        for (TransactionFee transactionFee : this.transactionFees) {
            if (transactionFee.getChargeType() != TransactionFee.ChargeType.A_RATE && transactionFee.getChargeType() != TransactionFee.ChargeType.MIXED_A_D_RATES) continue;
            result.add(transactionFee);
        }
        return result;
    }

    public Collection<AuthorizationLevel> getAuthorizationLevels() {
        return this.authorizationLevels;
    }

    public Collection<Channel> getChannels() {
        return this.channels;
    }

    public String getConfirmationMessage() {
        return this.confirmationMessage;
    }

    public Context getContext() {
        return this.context;
    }

    public Currency getCurrency() {
        try {
            return this.from.getCurrency();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Collection<PaymentCustomField> getCustomFields() {
        return this.customFields;
    }

    public String getDefaultFeedbackComments() {
        return this.defaultFeedbackComments;
    }

    public Reference.Level getDefaultFeedbackLevel() {
        return this.defaultFeedbackLevel;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<? extends TransactionFee> getDRatedFees() {
        ArrayList<TransactionFee> result = new ArrayList<TransactionFee>(this.transactionFees.size());
        for (TransactionFee transactionFee : this.transactionFees) {
            if (transactionFee.getChargeType() != TransactionFee.ChargeType.D_RATE && transactionFee.getChargeType() != TransactionFee.ChargeType.MIXED_A_D_RATES) continue;
            result.add(transactionFee);
        }
        return result;
    }

    public Calendar getFeedbackEnabledSince() {
        return this.feedbackEnabledSince;
    }

    public TimePeriod getFeedbackExpirationTime() {
        return this.feedbackExpirationTime;
    }

    public TimePeriod getFeedbackReplyExpirationTime() {
        return this.feedbackReplyExpirationTime;
    }

    public Member getFixedDestinationMember() {
        return this.fixedDestinationMember;
    }

    public AccountType getFrom() {
        return this.from;
    }

    public Collection<? extends AccountFee> getGeneratedByAccountFees() {
        return this.generatedByAccountFees;
    }

    public Collection<? extends TransactionFee> getGeneratedByTransactionFees() {
        return this.generatedByTransactionFees;
    }

    public Collection<? extends Group> getGroups() {
        return this.groups;
    }

    public Collection<? extends Group> getGroupsAsMember() {
        return this.groupsAsMember;
    }

    public Collection<PaymentCustomField> getLinkedCustomFields() {
        return this.linkedCustomFields;
    }

    public LoanParameters getLoan() {
        return this.loan;
    }

    public BigDecimal getMaxAmountPerDay() {
        return this.maxAmountPerDay;
    }

    public BigDecimal getMinAmount() {
        return this.minAmount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Collection<PaymentFilter> getPaymentFilters() {
        return this.paymentFilters;
    }

    public Collection<? extends TransactionFee> getRatedFees() {
        ArrayList<TransactionFee> result = new ArrayList<TransactionFee>(this.transactionFees.size());
        for (TransactionFee transactionFee : this.transactionFees) {
            if (transactionFee.getChargeType() != TransactionFee.ChargeType.A_RATE && transactionFee.getChargeType() != TransactionFee.ChargeType.D_RATE && transactionFee.getChargeType() != TransactionFee.ChargeType.MIXED_A_D_RATES) continue;
            result.add(transactionFee);
        }
        return result;
    }

    public AccountType getTo() {
        return this.to;
    }

    public Collection<? extends TransactionFee> getTransactionFees() {
        return this.transactionFees;
    }

    public TransactionHierarchyVisibility getTransactionHierarchyVisibility() {
        return this.transactionHierarchyVisibility;
    }

    public String getTransferListenerClass() {
        return this.transferListenerClass;
    }

    public boolean hasTransactionFees() {
        return !CollectionUtils.isEmpty(this.transactionFees);
    }

    public boolean isAllowBlockScheduledPayments() {
        return this.allowBlockScheduledPayments;
    }

    public boolean isAllowCancelScheduledPayments() {
        return this.allowCancelScheduledPayments;
    }

    public boolean isAllowSmsNotification() {
        return this.allowSmsNotification;
    }

    public boolean isAllowsScheduledPayments() {
        return this.allowsScheduledPayments;
    }

    public boolean isConciliable() {
        return this.conciliable;
    }

    public boolean isFromMember() {
        return !this.isFromSystem();
    }

    public boolean isFromSystem() {
        return this.from.getNature() == AccountType.Nature.SYSTEM;
    }

    public boolean isHavingAratedFees() {
        return this.getARatedFees().size() != 0;
    }

    public boolean isHavingDratedFees() {
        return this.getDRatedFees().size() != 0;
    }

    public boolean isHavingRatedFees() {
        return this.getRatedFees().size() != 0;
    }

    public boolean isLoanType() {
        return this.loan != null && this.loan.getType() != null;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public boolean isRequiresAuthorization() {
        return this.requiresAuthorization;
    }

    public boolean isRequiresFeedback() {
        return this.requiresFeedback;
    }

    public boolean isReserveTotalAmountOnScheduling() {
        return this.reserveTotalAmountOnScheduling;
    }

    public boolean isShowScheduledPaymentsToDestination() {
        return this.showScheduledPaymentsToDestination;
    }

    public boolean isToMember() {
        return !this.isToSystem();
    }

    public boolean isToSystem() {
        return this.to.getNature() == AccountType.Nature.SYSTEM;
    }

    public void setAllowBlockScheduledPayments(boolean allowBlockScheduledPayments) {
        this.allowBlockScheduledPayments = allowBlockScheduledPayments;
    }

    public void setAllowCancelScheduledPayments(boolean allowCancelScheduledPayments) {
        this.allowCancelScheduledPayments = allowCancelScheduledPayments;
    }

    public void setAllowSmsNotification(boolean allowSmsNotification) {
        this.allowSmsNotification = allowSmsNotification;
    }

    public void setAllowsScheduledPayments(boolean allowsScheduledPayments) {
        this.allowsScheduledPayments = allowsScheduledPayments;
    }

    public void setAuthorizationLevels(Collection<AuthorizationLevel> authorizationLevels) {
        this.authorizationLevels = authorizationLevels;
    }

    public void setChannels(Collection<Channel> channels) {
        this.channels = channels;
    }

    public void setConciliable(boolean conciliable) {
        this.conciliable = conciliable;
    }

    public void setConfirmationMessage(String confirmationMessage) {
        this.confirmationMessage = confirmationMessage;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setCustomFields(Collection<PaymentCustomField> customFields) {
        this.customFields = customFields;
    }

    public void setDefaultFeedbackComments(String defaultFeedbackComments) {
        this.defaultFeedbackComments = defaultFeedbackComments;
    }

    public void setDefaultFeedbackLevel(Reference.Level defaultFeedbackLevel) {
        this.defaultFeedbackLevel = defaultFeedbackLevel;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFeedbackEnabledSince(Calendar feedbackEnabledSince) {
        this.feedbackEnabledSince = feedbackEnabledSince;
    }

    public void setFeedbackExpirationTime(TimePeriod feedbackExpirationTime) {
        this.feedbackExpirationTime = feedbackExpirationTime;
    }

    public void setFeedbackReplyExpirationTime(TimePeriod feedbackReplyExpirationTime) {
        this.feedbackReplyExpirationTime = feedbackReplyExpirationTime;
    }

    public void setFixedDestinationMember(Member fixedDestinationMember) {
        this.fixedDestinationMember = fixedDestinationMember;
    }

    public void setFrom(AccountType from) {
        this.from = from;
    }

    public void setGeneratedByAccountFees(Collection<? extends AccountFee> generatedByAccountFees) {
        this.generatedByAccountFees = generatedByAccountFees;
    }

    public void setGeneratedByTransactionFees(Collection<? extends TransactionFee> generatedByTransactionFees) {
        this.generatedByTransactionFees = generatedByTransactionFees;
    }

    public void setGroups(Collection<? extends Group> groups) {
        this.groups = groups;
    }

    public void setGroupsAsMember(Collection<? extends Group> groupsAsMember) {
        this.groupsAsMember = groupsAsMember;
    }

    public void setLinkedCustomFields(Collection<PaymentCustomField> linkedCustomFields) {
        this.linkedCustomFields = linkedCustomFields;
    }

    public void setLoan(LoanParameters loan) {
        this.loan = loan;
        if (loan != null) {
            loan.setOriginalTransferType(this);
        }
    }

    public void setMaxAmountPerDay(BigDecimal maxAmountPerDay) {
        this.maxAmountPerDay = maxAmountPerDay;
    }

    public void setMinAmount(BigDecimal minAmount) {
        this.minAmount = minAmount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPaymentFilters(Collection<PaymentFilter> paymentFilters) {
        this.paymentFilters = paymentFilters;
    }

    public void setPriority(boolean priority) {
        this.priority = priority;
    }

    public void setRequiresAuthorization(boolean requiresAuthorization) {
        this.requiresAuthorization = requiresAuthorization;
    }

    public void setRequiresFeedback(boolean requiresFeedback) {
        this.requiresFeedback = requiresFeedback;
    }

    public void setReserveTotalAmountOnScheduling(boolean reserveTotalAmountOnScheduling) {
        this.reserveTotalAmountOnScheduling = reserveTotalAmountOnScheduling;
    }

    public void setShowScheduledPaymentsToDestination(boolean showScheduledPaymentsToDestination) {
        this.showScheduledPaymentsToDestination = showScheduledPaymentsToDestination;
    }

    public void setTo(AccountType to) {
        this.to = to;
    }

    public void setTransactionFees(Collection<? extends TransactionFee> transactionFees) {
        this.transactionFees = transactionFees;
    }

    public void setTransactionHierarchyVisibility(TransactionHierarchyVisibility transactionHierarchyVisibility) {
        this.transactionHierarchyVisibility = transactionHierarchyVisibility;
    }

    public void setTransferListenerClass(String transferListenerClass) {
        this.transferListenerClass = transferListenerClass;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.name;
    }

    public static enum TransactionHierarchyVisibility implements StringValuedEnum
    {
        ADMIN("A"),
        BROKER("B"),
        MEMBER("M");

        private final String value;

        private TransactionHierarchyVisibility(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean isVisibleTo(Group.Nature groupNature) {
            switch (groupNature) {
                case ADMIN: {
                    return true;
                }
                case BROKER: {
                    return this != ADMIN;
                }
                case MEMBER: 
                case OPERATOR: {
                    return this == MEMBER;
                }
            }
            return false;
        }
    }

    public static enum Relationships implements Relationship
    {
        FROM("from"),
        GROUPS("groups"),
        GROUPS_AS_MEMBER("groupsAsMember"),
        TO("to"),
        TRANSACTION_FEES("transactionFees"),
        GENERATED_BY_TRANSACTION_FEES("generatedByTransactionFees"),
        GENERATED_BY_ACCOUNT_FEES("generatedByAccountFees"),
        PAYMENT_FILTERS("paymentFilters"),
        AUTHORIZATION_LEVELS("authorizationLevels"),
        CUSTOM_FIELDS("customFields"),
        LINKED_CUSTOM_FIELDS("linkedCustomFields"),
        CHANNELS("channels");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Direction {
        FROM,
        TO,
        BOTH;

    }

    public static class Context
    implements Serializable {
        private static final long serialVersionUID = -7966654322680432255L;
        private boolean payment = false;
        private boolean selfPayment = false;

        public static Context payment() {
            Context context = new Context();
            context.setPayment(true);
            return context;
        }

        public static Context self() {
            Context context = new Context();
            context.setSelfPayment(true);
            return context;
        }

        public boolean isPayment() {
            return this.payment;
        }

        public boolean isSelfPayment() {
            return this.selfPayment;
        }

        public void setPayment(boolean payment) {
            this.payment = payment;
        }

        public void setSelfPayment(boolean selfPayment) {
            this.selfPayment = selfPayment;
        }
    }
}

