/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.ads;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Indexable;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.images.AdImage;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.CustomFieldsContainer;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import org.apache.commons.collections.CollectionUtils;

public class Ad
extends Entity
implements CustomFieldsContainer<AdCustomField, AdCustomFieldValue>,
Indexable {
    private static final long serialVersionUID = 1552286239776108655L;
    private AdCategory category;
    private Collection<AdCustomFieldValue> customValues;
    private String description;
    private boolean externalPublication;
    private Collection<AdImage> images;
    private Member owner;
    private boolean permanent;
    private Currency currency;
    private BigDecimal price;
    private Period publicationPeriod;
    private String title;
    private TradeType tradeType;
    private Calendar creationDate;
    private Calendar deleteDate;
    private boolean html;
    private boolean membersNotified;

    public AdCategory getCategory() {
        return this.category;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    public Class<AdCustomField> getCustomFieldClass() {
        return AdCustomField.class;
    }

    @Override
    public Class<AdCustomFieldValue> getCustomFieldValueClass() {
        return AdCustomFieldValue.class;
    }

    @Override
    public Collection<AdCustomFieldValue> getCustomValues() {
        return this.customValues;
    }

    public Calendar getDeleteDate() {
        return this.deleteDate;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<AdImage> getImages() {
        return this.images;
    }

    public Member getOwner() {
        return this.owner;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public Period getPublicationPeriod() {
        return this.publicationPeriod;
    }

    public Status getStatus() {
        if (this.permanent) {
            return Status.PERMANENT;
        }
        Calendar begin = this.publicationPeriod == null ? null : this.publicationPeriod.getBegin();
        Calendar end = this.publicationPeriod == null ? null : this.publicationPeriod.getEnd();
        Calendar now = Calendar.getInstance();
        if (begin != null && begin.after(now)) {
            return Status.SCHEDULED;
        }
        if (end != null && end.before(now)) {
            return Status.EXPIRED;
        }
        return Status.ACTIVE;
    }

    public String getTitle() {
        return this.title;
    }

    public TradeType getTradeType() {
        return this.tradeType;
    }

    public boolean isDeleted() {
        return this.getDeleteDate() != null;
    }

    public boolean isExternalPublication() {
        return this.externalPublication;
    }

    public boolean isHasImages() {
        return CollectionUtils.isNotEmpty(this.getImages());
    }

    public boolean isHtml() {
        return this.html;
    }

    public boolean isMembersNotified() {
        return this.membersNotified;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setCategory(AdCategory category) {
        this.category = category;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @Override
    public void setCustomValues(Collection<AdCustomFieldValue> customValues) {
        this.customValues = customValues;
    }

    public void setDeleteDate(Calendar deleteDate) {
        this.deleteDate = deleteDate;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExternalPublication(boolean externalPublication) {
        this.externalPublication = externalPublication;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public void setImages(Collection<AdImage> images) {
        this.images = images;
    }

    public void setMembersNotified(boolean notified) {
        this.membersNotified = notified;
    }

    public void setOwner(Member owner) {
        this.owner = owner;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public void setPublicationPeriod(Period publicationPeriod) {
        this.publicationPeriod = publicationPeriod;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTradeType(TradeType tradeType) {
        this.tradeType = tradeType;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.title;
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        variables.put("title", this.getTitle());
        variables.put("price", localSettings.getNumberConverter().toString(this.getPrice()));
    }

    public static enum TradeType implements StringValuedEnum
    {
        OFFER("O"),
        SEARCH("S");

        private final String value;

        private TradeType(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Status {
        ACTIVE(true),
        PERMANENT(true),
        SCHEDULED(false),
        EXPIRED(false);

        private final boolean active;

        private Status(boolean active) {
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }
    }

    public static enum Relationships implements Relationship
    {
        CATEGORY("category"),
        CURRENCY("currency"),
        CUSTOM_VALUES("customValues"),
        IMAGES("images"),
        OWNER("owner");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

