/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.ads;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import org.apache.commons.collections.CollectionUtils;

public class AdCategory
extends Entity
implements Comparable<AdCategory> {
    public static final int MAX_LEVEL = 3;
    private static final long serialVersionUID = -4371587757348684782L;
    private String name;
    private AdCategory parent;
    private Collection<AdCategory> children;
    private boolean active;
    private Integer order = 0;
    private BigInteger globalOrder;

    @Override
    public int compareTo(AdCategory other) {
        return this.getFullName().compareTo(other.getFullName());
    }

    public Collection<AdCategory> getChildren() {
        return this.children;
    }

    public String getFullName() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.getFullName() + ": " + this.name;
    }

    public String getFullNameButRoot() {
        if (this.getLevel() <= 2) {
            return this.name;
        }
        return this.parent.getFullNameButRoot() + ": " + this.name;
    }

    public BigInteger getGlobalOrder() {
        if (this.globalOrder == null) {
            int correctedLevel = 3 - this.getLevel();
            BigInteger levelFactor = new BigInteger("1000").pow(correctedLevel);
            Integer index = this.getOrder() == 0 ? 1 : this.getOrder();
            BigInteger parentGlobalOrder = this.getParent() == null ? BigInteger.ZERO : this.getParent().getGlobalOrder();
            this.globalOrder = parentGlobalOrder.add(levelFactor.multiply(new BigInteger(index.toString())));
        }
        return this.globalOrder;
    }

    public int getLevel() {
        if (this.parent == null) {
            return 1;
        }
        return 1 + this.parent.getLevel();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Integer getOrder() {
        return this.order;
    }

    public AdCategory getParent() {
        return this.parent;
    }

    public List<AdCategory> getPathFromRoot() {
        ArrayList<AdCategory> path = new ArrayList<AdCategory>();
        for (AdCategory current = this; current != null; current = current.getParent()) {
            path.add(current);
        }
        Collections.reverse(path);
        return path;
    }

    public AdCategory getRootCategory() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootCategory();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEnabled() {
        for (AdCategory current = this; current != null; current = current.getParent()) {
            if (current.isActive()) continue;
            return false;
        }
        return true;
    }

    public boolean isLeaf() {
        return CollectionUtils.isEmpty(this.children);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.globalOrder = null;
    }

    public void setChildren(Collection<AdCategory> children) {
        this.children = children;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrder(Integer orderIndex) {
        this.order = orderIndex;
        this.globalOrder = null;
    }

    public void setParent(AdCategory parent) {
        this.parent = parent;
        this.globalOrder = null;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.name;
    }

    public static enum Relationships implements Relationship
    {
        PARENT("parent"),
        CHILDREN("children");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

