/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.customization.documents;

import java.util.ArrayList;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.documents.DynamicDocument;
import nl.strohalm.cyclos.entities.customization.documents.MemberDocument;
import nl.strohalm.cyclos.entities.customization.documents.StaticDocument;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public abstract class Document
extends Entity {
    private static final long serialVersionUID = -2006379424571494005L;
    private String name;
    private String description;
    private Collection<SystemGroup> groups;
    private Collection<BrokerGroup> brokerGroups;

    public void addGroup(SystemGroup g) {
        if (this.groups == null) {
            this.groups = new ArrayList<SystemGroup>();
        }
        this.groups.add(g);
    }

    public Collection<BrokerGroup> getBrokerGroups() {
        return this.brokerGroups;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<SystemGroup> getGroups() {
        return this.groups;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public abstract Nature getNature();

    public void setBrokerGroups(Collection<BrokerGroup> brokerGroups) {
        this.brokerGroups = brokerGroups;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGroups(Collection<SystemGroup> groups) {
        this.groups = groups;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.name;
    }

    public static enum Relationships implements Relationship
    {
        GROUPS("groups"),
        BROKER_GROUPS("brokerGroups");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Nature implements StringValuedEnum
    {
        DYNAMIC("D"),
        STATIC("S"),
        MEMBER("M");

        private String value;

        private Nature(String value) {
            this.value = value;
        }

        public Class<? extends Document> getType() {
            return this == DYNAMIC ? DynamicDocument.class : (this == STATIC ? StaticDocument.class : MemberDocument.class);
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

