/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.customization.fields;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.AdminCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdminCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.LoanGroupCustomField;
import nl.strohalm.cyclos.entities.customization.fields.LoanGroupCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.OperatorCustomField;
import nl.strohalm.cyclos.entities.customization.fields.OperatorCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.Validation;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public abstract class CustomField
extends Entity {
    private static final long serialVersionUID = 124467598010653164L;
    private String name;
    private String internalName;
    private String description;
    private String allSelectedLabel;
    private Type type = Type.STRING;
    private Control control = Control.TEXT;
    private Size size = Size.DEFAULT;
    private Validation validation = new Validation();
    private String pattern;
    private Integer order = 0;
    private Collection<CustomFieldPossibleValue> possibleValues;
    private CustomField parent;
    private Collection<CustomField> children;

    public String getAllSelectedLabel() {
        return this.allSelectedLabel;
    }

    public Collection<CustomField> getChildren() {
        return this.children;
    }

    public Control getControl() {
        return this.control;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Nature getNature() {
        if (this instanceof AdCustomField) {
            return Nature.AD;
        }
        if (this instanceof AdminCustomField) {
            return Nature.ADMIN;
        }
        if (this instanceof PaymentCustomField) {
            return Nature.PAYMENT;
        }
        if (this instanceof LoanGroupCustomField) {
            return Nature.LOAN_GROUP;
        }
        if (this instanceof MemberCustomField) {
            return Nature.MEMBER;
        }
        if (this instanceof OperatorCustomField) {
            return Nature.OPERATOR;
        }
        if (this instanceof MemberRecordCustomField) {
            return Nature.MEMBER_RECORD;
        }
        return null;
    }

    public Integer getOrder() {
        return this.order;
    }

    public CustomField getParent() {
        return this.parent;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Collection<CustomFieldPossibleValue> getPossibleValues() {
        return this.possibleValues;
    }

    public Collection<CustomFieldPossibleValue> getPossibleValues(final Boolean onlyEnabled) {
        ArrayList<CustomFieldPossibleValue> filteredPossibleValues = new ArrayList<CustomFieldPossibleValue>(this.possibleValues);
        CollectionUtils.filter(filteredPossibleValues, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                CustomFieldPossibleValue possibleValue = (CustomFieldPossibleValue)object;
                return onlyEnabled != false ? possibleValue.isEnabled() : true;
            }
        });
        return this.possibleValues;
    }

    public Collection<CustomFieldPossibleValue> getPossibleValuesByParent(final CustomFieldPossibleValue parentValue, final Boolean onlyEnabled) {
        if (this.parent == null) {
            return this.possibleValues;
        }
        if (this.possibleValues == null || parentValue == null || !this.parent.equals(parentValue.getField())) {
            return Collections.emptyList();
        }
        ArrayList<CustomFieldPossibleValue> filteredPossibleValues = new ArrayList<CustomFieldPossibleValue>(this.possibleValues);
        CollectionUtils.filter(filteredPossibleValues, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                CustomFieldPossibleValue possibleValue = (CustomFieldPossibleValue)object;
                return parentValue.equals(possibleValue.getParent()) && (onlyEnabled == false || possibleValue.isEnabled());
            }
        });
        return filteredPossibleValues;
    }

    public Size getSize() {
        return this.size;
    }

    public Type getType() {
        return this.type;
    }

    public Validation getValidation() {
        return this.validation;
    }

    public void setAllSelectedLabel(String allSelectedLabel) {
        this.allSelectedLabel = allSelectedLabel;
    }

    public void setChildren(Collection<CustomField> children) {
        this.children = children;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setParent(CustomField parent) {
        this.parent = parent;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setPossibleValues(Collection<CustomFieldPossibleValue> possibleValues) {
        this.possibleValues = possibleValues;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.name;
    }

    public static enum Type implements StringValuedEnum
    {
        STRING("string", Control.TEXT, Control.TEXTAREA, Control.RICH_EDITOR),
        ENUMERATED("enum", Control.SELECT, Control.RADIO),
        INTEGER("integer", Control.TEXT),
        DECIMAL("decimal", Control.TEXT),
        DATE("date", Control.TEXT),
        BOOLEAN("boolean", Control.CHECKBOX),
        URL("url", Control.TEXT),
        MEMBER("member", Control.MEMBER_AUTOCOMPLETE);

        private final String value;
        private final List<Control> possibleControls;

        private Type(String value, Control ... possibleControls) {
            this.value = value;
            this.possibleControls = Collections.unmodifiableList(Arrays.asList(possibleControls));
        }

        public List<Control> getPossibleControls() {
            return this.possibleControls;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Size implements StringValuedEnum
    {
        DEFAULT("D"),
        TINY("T"),
        SMALL("S"),
        MEDIUM("M"),
        LARGE("L"),
        FULL("F");

        private final String value;

        private Size(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        POSSIBLE_VALUES("possibleValues"),
        PARENT("parent"),
        CHILDREN("children");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Nature implements StringValuedEnum
    {
        AD("ad"),
        ADMIN("admin"),
        PAYMENT("payment"),
        LOAN_GROUP("loan_group"),
        MEMBER("member"),
        OPERATOR("op"),
        MEMBER_RECORD("member_record");

        private final String value;

        public static Nature getByOwner(Object owner) {
            return owner == null ? null : Nature.getByOwnerType(owner.getClass());
        }

        public static Nature getByOwnerType(Class<?> ownerType) {
            if (Ad.class.isAssignableFrom(ownerType)) {
                return AD;
            }
            if (Member.class.isAssignableFrom(ownerType)) {
                return MEMBER;
            }
            if (Administrator.class.isAssignableFrom(ownerType)) {
                return ADMIN;
            }
            if (Operator.class.isAssignableFrom(ownerType)) {
                return OPERATOR;
            }
            if (Payment.class.isAssignableFrom(ownerType) || DoPaymentDTO.class.isAssignableFrom(ownerType) || Invoice.class.isAssignableFrom(ownerType) || Guarantee.class.isAssignableFrom(ownerType)) {
                return PAYMENT;
            }
            if (LoanGroup.class.isAssignableFrom(ownerType)) {
                return LOAN_GROUP;
            }
            if (MemberRecord.class.isAssignableFrom(ownerType)) {
                return MEMBER_RECORD;
            }
            return null;
        }

        private Nature(String value) {
            this.value = value;
        }

        public Class<? extends CustomField> getEntityType() {
            switch (this) {
                case AD: {
                    return AdCustomField.class;
                }
                case ADMIN: {
                    return AdminCustomField.class;
                }
                case PAYMENT: {
                    return PaymentCustomField.class;
                }
                case LOAN_GROUP: {
                    return LoanGroupCustomField.class;
                }
                case MEMBER: {
                    return MemberCustomField.class;
                }
                case OPERATOR: {
                    return OperatorCustomField.class;
                }
                case MEMBER_RECORD: {
                    return MemberRecordCustomField.class;
                }
            }
            return null;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public Class<? extends CustomFieldValue> getValueType() {
            switch (this) {
                case AD: {
                    return AdCustomFieldValue.class;
                }
                case ADMIN: {
                    return AdminCustomFieldValue.class;
                }
                case PAYMENT: {
                    return PaymentCustomFieldValue.class;
                }
                case LOAN_GROUP: {
                    return LoanGroupCustomFieldValue.class;
                }
                case MEMBER: {
                    return MemberCustomFieldValue.class;
                }
                case OPERATOR: {
                    return OperatorCustomFieldValue.class;
                }
                case MEMBER_RECORD: {
                    return MemberRecordCustomFieldValue.class;
                }
            }
            return null;
        }
    }

    public static enum Control implements StringValuedEnum
    {
        TEXT("text", true),
        TEXTAREA("textarea", true),
        RICH_EDITOR("richEditor", false),
        SELECT("select", true),
        RADIO("radio", true),
        CHECKBOX("checkbox", false),
        MEMBER_AUTOCOMPLETE("member", false);

        private final String value;
        private final boolean useSize;

        private Control(String value, boolean useSize) {
            this.value = value;
            this.useSize = useSize;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean isUseSize() {
            return this.useSize;
        }
    }
}

