/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.customization.fields;

import java.util.Collection;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public class MemberCustomField
extends CustomField {
    private static final long serialVersionUID = 8982250513905556430L;
    private Access adSearchAccess = Access.NONE;
    private Access loanSearchAccess = Access.NONE;
    private boolean memberCanHide = true;
    private Access memberSearchAccess = Access.NONE;
    private Access visibilityAccess = Access.OTHER;
    private Access updateAccess = Access.MEMBER;
    private boolean showInPrint = true;
    private Indexing indexing = Indexing.MEMBERS_AND_ADS;
    private Collection<MemberGroup> groups;

    public Access getAdSearchAccess() {
        return this.adSearchAccess;
    }

    public Collection<MemberGroup> getGroups() {
        return this.groups;
    }

    public Indexing getIndexing() {
        return this.indexing;
    }

    public Access getLoanSearchAccess() {
        return this.loanSearchAccess;
    }

    public Access getMemberSearchAccess() {
        return this.memberSearchAccess;
    }

    public Access getUpdateAccess() {
        return this.updateAccess;
    }

    public Access getVisibilityAccess() {
        return this.visibilityAccess;
    }

    public boolean isMemberCanHide() {
        return this.memberCanHide;
    }

    public boolean isShowInPrint() {
        return this.showInPrint;
    }

    public void setAdSearchAccess(Access adSearchVisibility) {
        this.adSearchAccess = adSearchVisibility;
    }

    public void setGroups(Collection<MemberGroup> groups) {
        this.groups = groups;
    }

    public void setIndexing(Indexing indexing) {
        this.indexing = indexing;
    }

    public void setLoanSearchAccess(Access loanSearchVisibility) {
        this.loanSearchAccess = loanSearchVisibility;
    }

    public void setMemberCanHide(boolean memberCanHide) {
        this.memberCanHide = memberCanHide;
    }

    public void setMemberSearchAccess(Access memberSearchVisibility) {
        this.memberSearchAccess = memberSearchVisibility;
    }

    public void setShowInPrint(boolean showInPrint) {
        this.showInPrint = showInPrint;
    }

    public void setUpdateAccess(Access editableAccess) {
        this.updateAccess = editableAccess;
    }

    public void setVisibilityAccess(Access registrationVisibility) {
        this.visibilityAccess = registrationVisibility;
    }

    public static enum Relationships implements Relationship
    {
        GROUPS("groups");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Indexing implements StringValuedEnum
    {
        NONE("N"),
        MEMBERS_ONLY("M"),
        MEMBERS_AND_ADS("A");

        private final String value;

        private Indexing(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Access implements StringValuedEnum
    {
        NONE("N"),
        WEB_SERVICE("W"),
        ADMIN("A"),
        BROKER("B"),
        REGISTRATION("R"),
        MEMBER_NOT_REGISTRATION("T"),
        MEMBER("M"),
        OTHER("O"),
        MEMBER_NOT_OPERATOR("P");

        private final String value;

        private Access(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean granted(Group group, boolean byOwner, boolean byBroker, boolean atRegistration, boolean byWebService) {
            if (byWebService) {
                return this != NONE;
            }
            boolean isGranted = this.granted(group);
            if (isGranted && group instanceof MemberGroup) {
                switch (this) {
                    case MEMBER: {
                        isGranted = byOwner || byBroker;
                        break;
                    }
                    case MEMBER_NOT_REGISTRATION: {
                        isGranted = !atRegistration && (byOwner || byBroker);
                        break;
                    }
                    case REGISTRATION: {
                        isGranted = atRegistration || byBroker;
                        break;
                    }
                    case BROKER: {
                        isGranted = byBroker;
                    }
                }
            }
            return isGranted;
        }

        public boolean grantedToBroker() {
            return this != NONE && this != ADMIN && this != WEB_SERVICE;
        }

        private boolean granted(Group group) {
            switch (this) {
                case NONE: {
                    return false;
                }
                case BROKER: {
                    return group instanceof BrokerGroup || group instanceof AdminGroup;
                }
                case ADMIN: {
                    return group instanceof AdminGroup;
                }
                case MEMBER: 
                case MEMBER_NOT_REGISTRATION: 
                case REGISTRATION: 
                case MEMBER_NOT_OPERATOR: {
                    return !(group instanceof OperatorGroup);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
    }
}

