/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.customization.fields;

import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.members.imports.ImportedMember;

public class MemberCustomFieldValue
extends CustomFieldValue {
    private static final long serialVersionUID = -2784135085280294105L;
    private Member member;
    private PendingMember pendingMember;
    private ImportedMember importedMember;
    private boolean hidden;

    public ImportedMember getImportedMember() {
        return this.importedMember;
    }

    public Member getMember() {
        return this.member;
    }

    @Override
    public Object getOwner() {
        if (this.importedMember != null) {
            return this.importedMember;
        }
        if (this.pendingMember != null) {
            return this.pendingMember;
        }
        return this.member;
    }

    public PendingMember getPendingMember() {
        return this.pendingMember;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setImportedMember(ImportedMember importedMember) {
        this.importedMember = importedMember;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    @Override
    public void setOwner(Object owner) {
        if (owner instanceof PendingMember) {
            this.setPendingMember((PendingMember)owner);
            this.setImportedMember(null);
            this.setMember(null);
        } else if (owner instanceof ImportedMember) {
            this.setImportedMember((ImportedMember)owner);
            this.setPendingMember(null);
            this.setMember(null);
        } else if (owner instanceof Member) {
            this.setMember((Member)owner);
            this.setImportedMember(null);
            this.setPendingMember(null);
        } else {
            throw new IllegalArgumentException(String.format("Invalid owner (%1$s) for custom field value: %2$s", owner, this.getClass().getSimpleName()));
        }
    }

    public void setPendingMember(PendingMember pendingMember) {
        this.pendingMember = pendingMember;
    }

    public static enum Relationships implements Relationship
    {
        MEMBER("member"),
        PENDING_MEMBER("pendingMember"),
        IMPORTED_MEMBER("importedMember");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

