/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.customization.files;

import java.io.FilenameFilter;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.files.File;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.StringUtils;

public class CustomizedFile
extends File {
    private static final long serialVersionUID = 3264704140933610339L;
    private Type type;
    private Group group;
    private GroupFilter groupFilter;
    private String originalContents;
    private String newContents;

    public Group getGroup() {
        return this.group;
    }

    public GroupFilter getGroupFilter() {
        return this.groupFilter;
    }

    public String getNewContents() {
        return this.newContents;
    }

    public String getOriginalContents() {
        return this.originalContents;
    }

    public String getRelativePath() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(47);
        return name.substring(0, index);
    }

    public Type getType() {
        return this.type;
    }

    public boolean isConflict() {
        return StringUtils.isNotEmpty((String)this.newContents);
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public void setGroupFilter(GroupFilter groupFilter) {
        this.groupFilter = groupFilter;
    }

    public void setNewContents(String newContents) {
        this.newContents = StringHelper.removeCarriageReturnCharater(newContents);
    }

    public void setOriginalContents(String originalContents) {
        this.originalContents = StringHelper.removeCarriageReturnCharater(originalContents);
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public String toString() {
        Group group = this.getGroup();
        if (group == null && this.groupFilter == null) {
            return super.toString();
        }
        return this.getId() + " - " + this.getName() + " for " + (group == null ? this.groupFilter : group);
    }

    public static enum Type implements StringValuedEnum
    {
        STATIC_FILE("S", "jsp"),
        STYLE("C", "css"),
        HELP("H", "jsp"),
        APPLICATION_PAGE("A", "jsp");

        private final String value;
        private final FilenameFilter filter;

        private Type(String value, String extension) {
            this.value = value;
            this.filter = new SuffixFileFilter("." + extension);
        }

        public FilenameFilter getFilter() {
            return this.filter;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        GROUP("group"),
        GROUP_FILTER("groupFilter");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

