/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.customization.images;

import java.sql.Blob;
import java.util.Calendar;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.customization.images.AdImage;
import nl.strohalm.cyclos.entities.customization.images.CustomImage;
import nl.strohalm.cyclos.entities.customization.images.MemberImage;
import nl.strohalm.cyclos.entities.customization.images.StyleImage;
import nl.strohalm.cyclos.entities.customization.images.SystemImage;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public abstract class Image
extends Entity {
    private static final long serialVersionUID = 3550019581431328393L;
    private String contentType;
    private Blob image;
    private Integer imageSize;
    private Calendar lastModified;
    private String name;
    private Blob thumbnail;
    private Integer thumbnailSize;

    protected Image() {
    }

    public String getContentType() {
        return this.contentType;
    }

    public Blob getImage() {
        return this.image;
    }

    public Integer getImageSize() {
        return this.imageSize;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public abstract Nature getNature();

    public String getSimpleName() {
        int pos;
        int n = pos = this.name == null ? -1 : this.name.lastIndexOf(46);
        if (pos < 0) {
            return this.name;
        }
        return this.name.substring(0, pos);
    }

    public Blob getThumbnail() {
        return this.thumbnail;
    }

    public Integer getThumbnailSize() {
        return this.thumbnailSize;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setImage(Blob image) {
        this.image = image;
    }

    public void setImageSize(Integer imageSize) {
        this.imageSize = imageSize;
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThumbnail(Blob thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setThumbnailSize(Integer thumbnailSize) {
        this.thumbnailSize = thumbnailSize;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.name;
    }

    public static enum Nature implements StringValuedEnum
    {
        SYSTEM("sys"),
        CUSTOM("ctm"),
        STYLE("sty"),
        MEMBER("mbr"),
        AD("ad");

        private final String value;

        public static Nature getByOwner(Entity owner) {
            if (owner instanceof Member) {
                return MEMBER;
            }
            return AD;
        }

        private Nature(String value) {
            this.value = value;
        }

        public Class<? extends Image> getEntityType() {
            switch (this) {
                case AD: {
                    return AdImage.class;
                }
                case CUSTOM: {
                    return CustomImage.class;
                }
                case SYSTEM: {
                    return SystemImage.class;
                }
                case MEMBER: {
                    return MemberImage.class;
                }
                case STYLE: {
                    return StyleImage.class;
                }
            }
            return null;
        }

        public String getOwnerProperty() {
            switch (this) {
                case AD: {
                    return "ad";
                }
                case MEMBER: {
                    return "member";
                }
            }
            return null;
        }

        public Class<? extends Entity> getOwnerType() {
            switch (this) {
                case AD: {
                    return Ad.class;
                }
                case MEMBER: {
                    return Member.class;
                }
            }
            return null;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

