/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.exceptions;

import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.utils.ClassHelper;

public class EntityNotFoundException
extends DaoException {
    private static final long serialVersionUID = -140981929520364831L;
    private final Class<? extends Entity> entityType;
    private final Long id;

    private static String messageFor(Class<? extends Entity> entityType, Long id, String message) {
        if (message == null) {
            message = "";
        }
        if (entityType == null) {
            return "The specified entity was not found. " + message;
        }
        if (id == null) {
            return "The specified " + ClassHelper.getClassName(entityType) + " was not found. " + message;
        }
        return "Entity not found: " + ClassHelper.getClassName(entityType) + "#" + id + ". " + message;
    }

    public EntityNotFoundException() {
        this(null, null, null);
    }

    public EntityNotFoundException(Class<? extends Entity> entityType) {
        this(entityType, null, null);
    }

    public EntityNotFoundException(Class<? extends Entity> entityType, Long id) {
        this(entityType, id, null);
    }

    public EntityNotFoundException(Class<? extends Entity> entityType, Long id, String message) {
        super(EntityNotFoundException.messageFor(entityType, id, message));
        this.entityType = entityType;
        this.id = id;
    }

    public EntityNotFoundException(String message) {
        this(null, null, message);
    }

    public Class<? extends Entity> getEntityType() {
        return this.entityType;
    }

    public Long getId() {
        return this.id;
    }
}

