/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.groups;

import nl.strohalm.cyclos.entities.access.TransactionPassword;
import nl.strohalm.cyclos.utils.DataObject;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.TimePeriod;

public class BasicGroupSettings
extends DataObject {
    private static final long serialVersionUID = 1292266261711753784L;
    private RangeConstraint passwordLength = new RangeConstraint(4, 12);
    private PasswordPolicy passwordPolicy = PasswordPolicy.AVOID_OBVIOUS;
    private int maxPasswordWrongTries = 3;
    private TimePeriod deactivationAfterMaxPasswordTries = new TimePeriod(10, TimePeriod.Field.MINUTES);
    private TimePeriod passwordExpiresAfter = new TimePeriod(0, TimePeriod.Field.MONTHS);
    private TransactionPassword transactionPassword = TransactionPassword.NOT_USED;
    private int transactionPasswordLength = 4;
    private int maxTransactionPasswordWrongTries = 3;
    private boolean hideCurrencyOnPayments;

    public TimePeriod getDeactivationAfterMaxPasswordTries() {
        return this.deactivationAfterMaxPasswordTries;
    }

    public int getMaxPasswordWrongTries() {
        return this.maxPasswordWrongTries;
    }

    public int getMaxTransactionPasswordWrongTries() {
        return this.maxTransactionPasswordWrongTries;
    }

    public TimePeriod getPasswordExpiresAfter() {
        return this.passwordExpiresAfter;
    }

    public RangeConstraint getPasswordLength() {
        return this.passwordLength;
    }

    public PasswordPolicy getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public TransactionPassword getTransactionPassword() {
        return this.transactionPassword;
    }

    public int getTransactionPasswordLength() {
        return this.transactionPasswordLength;
    }

    public boolean isHideCurrencyOnPayments() {
        return this.hideCurrencyOnPayments;
    }

    public void setDeactivationAfterMaxPasswordTries(TimePeriod deactivationAfterWrongPasswords) {
        this.deactivationAfterMaxPasswordTries = deactivationAfterWrongPasswords;
    }

    public void setHideCurrencyOnPayments(boolean hideCurrencyOnPayments) {
        this.hideCurrencyOnPayments = hideCurrencyOnPayments;
    }

    public void setMaxPasswordWrongTries(int maxPasswordWrongTries) {
        this.maxPasswordWrongTries = maxPasswordWrongTries;
    }

    public void setMaxTransactionPasswordWrongTries(int maxTransactionPasswordWrongTrials) {
        this.maxTransactionPasswordWrongTries = maxTransactionPasswordWrongTrials;
    }

    public void setPasswordExpiresAfter(TimePeriod passwordExpiresAfter) {
        this.passwordExpiresAfter = passwordExpiresAfter;
    }

    public void setPasswordLength(RangeConstraint passwordLength) {
        this.passwordLength = passwordLength;
    }

    public void setPasswordPolicy(PasswordPolicy passwordPolicy) {
        this.passwordPolicy = passwordPolicy == null ? PasswordPolicy.NONE : passwordPolicy;
    }

    public void setTransactionPassword(TransactionPassword transactionPassword) {
        this.transactionPassword = transactionPassword;
    }

    public void setTransactionPasswordLength(int transactionPasswordLength) {
        this.transactionPasswordLength = transactionPasswordLength;
    }

    public static enum PasswordPolicy implements StringValuedEnum
    {
        NONE("N", false),
        AVOID_OBVIOUS("O", false),
        AVOID_OBVIOUS_LETTERS_NUMBERS("L", true),
        AVOID_OBVIOUS_LETTERS_NUMBERS_SPECIAL("S", true);

        private final String value;
        private final boolean forceCharacters;

        private PasswordPolicy(String value, boolean forceCharacters) {
            this.value = value;
            this.forceCharacters = forceCharacters;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean isForceCharacters() {
            return this.forceCharacters;
        }
    }
}

