/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BasicGroupSettings;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.GroupHistoryLog;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.entities.members.remarks.GroupRemark;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public abstract class Group
extends Entity
implements Comparable<Group> {
    private static final long serialVersionUID = 3079265000327578016L;
    private String description;
    private Collection<Element> elements;
    private String name;
    private Collection<PaymentFilter> paymentFilters;
    private Collection<Permission> permissions;
    private Status status = Status.NORMAL;
    private BasicGroupSettings basicSettings = new BasicGroupSettings();
    private Collection<TransferType> transferTypes;
    private Collection<TransferType> conversionSimulationTTs;
    private Collection<CustomizedFile> customizedFiles;
    private Collection<GroupFilter> groupFilters;
    private Collection<MemberRecordType> memberRecordTypes;
    private Collection<GuaranteeType> guaranteeTypes;
    private Collection<GroupHistoryLog> historyLogs;
    private Collection<GroupRemark> oldRemarks;
    private Collection<GroupRemark> newRemarks;

    @Override
    public int compareTo(Group o) {
        return this.name.compareTo(o.getName());
    }

    public BasicGroupSettings getBasicSettings() {
        return this.basicSettings;
    }

    public Collection<TransferType> getConversionSimulationTTs() {
        return this.conversionSimulationTTs;
    }

    public Collection<CustomizedFile> getCustomizedFiles() {
        return this.customizedFiles;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<? extends Element> getElements() {
        return this.elements;
    }

    public Collection<GuaranteeType> getEnabledGuaranteeTypes() {
        Collection<GuaranteeType> all = this.getGuaranteeTypes();
        if (all == null || all.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GuaranteeType> enabled = new ArrayList<GuaranteeType>();
        for (GuaranteeType gt : all) {
            if (!gt.isEnabled()) continue;
            enabled.add(gt);
        }
        return enabled;
    }

    public Collection<GroupFilter> getGroupFilters() {
        return this.groupFilters;
    }

    public Collection<GuaranteeType> getGuaranteeTypes() {
        return this.guaranteeTypes;
    }

    public Collection<GroupHistoryLog> getHistoryLogs() {
        return this.historyLogs;
    }

    public Collection<MemberRecordType> getMemberRecordTypes() {
        return this.memberRecordTypes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public abstract Nature getNature();

    public Collection<GroupRemark> getNewRemarks() {
        return this.newRemarks;
    }

    public Collection<GroupRemark> getOldRemarks() {
        return this.oldRemarks;
    }

    public Collection<PaymentFilter> getPaymentFilters() {
        return this.paymentFilters;
    }

    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public Status getStatus() {
        return this.status;
    }

    public Collection<TransferType> getTransferTypes() {
        return this.transferTypes;
    }

    public boolean isRemoved() {
        return this.status == Status.REMOVED;
    }

    public void setBasicSettings(BasicGroupSettings basicSettings) {
        if (basicSettings == null) {
            basicSettings = new BasicGroupSettings();
        }
        this.basicSettings = basicSettings;
    }

    public void setConversionSimulationTTs(Collection<TransferType> conversionSimulationTTs) {
        this.conversionSimulationTTs = conversionSimulationTTs;
    }

    public void setCustomizedFiles(Collection<CustomizedFile> customizedFiles) {
        this.customizedFiles = customizedFiles;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setElements(Collection<Element> elements) {
        this.elements = elements;
    }

    public void setGroupFilters(Collection<GroupFilter> groupFilters) {
        this.groupFilters = groupFilters;
    }

    public void setGuaranteeTypes(Collection<GuaranteeType> guaranteeTypes) {
        this.guaranteeTypes = guaranteeTypes;
    }

    public void setHistoryLogs(Collection<GroupHistoryLog> historyLogs) {
        this.historyLogs = historyLogs;
    }

    public void setMemberRecordTypes(Collection<MemberRecordType> memberRecordTypes) {
        this.memberRecordTypes = memberRecordTypes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNewRemarks(Collection<GroupRemark> newRemarks) {
        this.newRemarks = newRemarks;
    }

    public void setOldRemarks(Collection<GroupRemark> oldRemarks) {
        this.oldRemarks = oldRemarks;
    }

    public void setPaymentFilters(Collection<PaymentFilter> paymentFilters) {
        this.paymentFilters = paymentFilters;
    }

    public void setPermissions(Collection<Permission> permissions) {
        this.permissions = permissions;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setTransferTypes(Collection<TransferType> transferTypes) {
        this.transferTypes = transferTypes;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.name;
    }

    public static enum Status implements StringValuedEnum
    {
        NORMAL("N"),
        REMOVED("R");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean isEnabled() {
            return this == NORMAL;
        }
    }

    public static enum Relationships implements Relationship
    {
        ELEMENTS("elements"),
        PAYMENT_FILTERS("paymentFilters"),
        GROUP_FILTERS("groupFilters"),
        PERMISSIONS("permissions"),
        TRANSFER_TYPES("transferTypes"),
        CONVERSION_SIMULATION_TTS("conversionSimulationTTs"),
        CUSTOMIZED_FILES("customizedFiles"),
        GUARANTEE_TYPES("guaranteeTypes");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Nature {
        ADMIN("A"),
        MEMBER("M"),
        BROKER("B"),
        OPERATOR("O");

        private final String discriminator;

        private Nature(String discriminator) {
            this.discriminator = discriminator;
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public Element.Nature getElementNature() {
            switch (this) {
                case ADMIN: {
                    return Element.Nature.ADMIN;
                }
                case MEMBER: 
                case BROKER: {
                    return Element.Nature.MEMBER;
                }
                case OPERATOR: {
                    return Element.Nature.OPERATOR;
                }
            }
            return null;
        }

        public Class<? extends Group> getGroupClass() {
            switch (this) {
                case ADMIN: {
                    return AdminGroup.class;
                }
                case MEMBER: {
                    return MemberGroup.class;
                }
                case BROKER: {
                    return BrokerGroup.class;
                }
                case OPERATOR: {
                    return OperatorGroup.class;
                }
            }
            return null;
        }
    }
}

