/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.groups;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.collections.CollectionUtils;

public class GroupQuery
extends QueryParameters {
    private static final long serialVersionUID = -7827163668106032570L;
    private Collection<Group> possibleGroups;
    private Collection<GroupFilter> groupFilters;
    private Group.Nature[] natures;
    private Group.Status[] status;
    private MemberAccountType memberAccountType;
    private PaymentFilter paymentFilter;
    private AdminGroup managedBy;
    private Member member;
    private boolean ignoreManagedBy;
    private boolean sortByNature;
    private boolean onlyActive;
    private Member broker;

    public Member getBroker() {
        return this.broker;
    }

    public GroupFilter getGroupFilter() {
        return CollectionUtils.isNotEmpty(this.groupFilters) ? this.groupFilters.iterator().next() : null;
    }

    public Collection<GroupFilter> getGroupFilters() {
        return this.groupFilters;
    }

    public AdminGroup getManagedBy() {
        return this.managedBy;
    }

    public Member getMember() {
        return this.member;
    }

    public MemberAccountType getMemberAccountType() {
        return this.memberAccountType;
    }

    public Group.Nature getNature() {
        if (this.natures == null || this.natures.length == 0) {
            return null;
        }
        return this.natures[0];
    }

    public Collection<String> getNatureDiscriminators() {
        if (this.natures == null || this.natures.length == 0) {
            return null;
        }
        HashSet<String> discriminators = new HashSet<String>();
        for (Group.Nature nature : this.natures) {
            discriminators.add(nature.getDiscriminator());
        }
        return discriminators;
    }

    public Group.Nature[] getNatures() {
        return this.natures;
    }

    public Collection<Group.Nature> getNaturesCollection() {
        return this.natures == null ? null : Arrays.asList(this.natures);
    }

    public Collection<Group.Nature> getNaturesList() {
        if (this.natures != null) {
            return Arrays.asList(this.natures);
        }
        return null;
    }

    public PaymentFilter getPaymentFilter() {
        return this.paymentFilter;
    }

    public Collection<Group> getPossibleGroups() {
        return this.possibleGroups;
    }

    public Group.Status[] getStatus() {
        return this.status;
    }

    public Collection<Group.Status> getStatusCollection() {
        return this.status == null || this.status.length == 0 ? null : Arrays.asList(this.status);
    }

    public boolean isIgnoreManagedBy() {
        return this.ignoreManagedBy;
    }

    public boolean isOnlyActive() {
        return this.onlyActive;
    }

    public boolean isSortByNature() {
        return this.sortByNature;
    }

    public void setBroker(Member broker) {
        this.broker = broker;
    }

    public void setGroupFilter(GroupFilter groupFilter) {
        this.groupFilters = groupFilter == null ? null : Collections.singletonList(groupFilter);
    }

    public void setGroupFilters(Collection<GroupFilter> groupFilters) {
        this.groupFilters = groupFilters;
    }

    public void setIgnoreManagedBy(boolean ignoreManagedBy) {
        this.ignoreManagedBy = ignoreManagedBy;
    }

    public void setManagedBy(AdminGroup managedBy) {
        this.managedBy = managedBy;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public void setMemberAccountType(MemberAccountType memberAccountType) {
        this.memberAccountType = memberAccountType;
    }

    public void setNature(Group.Nature nature) {
        Group.Nature[] natureArray;
        if (nature == null) {
            natureArray = null;
        } else {
            Group.Nature[] natureArray2 = new Group.Nature[1];
            natureArray = natureArray2;
            natureArray2[0] = nature;
        }
        this.natures = natureArray;
    }

    public void setNatures(Group.Nature ... natures) {
        this.natures = natures;
    }

    public void setNaturesCollection(Collection<Group.Nature> natures) {
        this.natures = natures == null ? null : natures.toArray(new Group.Nature[natures.size()]);
    }

    public void setOnlyActive(boolean onlyActive) {
        this.onlyActive = onlyActive;
    }

    public void setPaymentFilter(PaymentFilter paymentFilter) {
        this.paymentFilter = paymentFilter;
    }

    public void setPossibleGroups(Collection<Group> possibleGroups) {
        this.possibleGroups = possibleGroups;
    }

    public void setSortByNature(boolean sortByNature) {
        this.sortByNature = sortByNature;
    }

    public void setStatus(Group.Status ... status) {
        this.status = status;
    }

    public void setStatusCollection(Collection<Group.Status> status) {
        this.status = status == null ? null : status.toArray(new Group.Status[status.size()]);
    }
}

