/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.groups;

import java.util.Collection;
import java.util.HashSet;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.cards.CardType;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.RegistrationAgreement;
import nl.strohalm.cyclos.entities.members.messages.Message;

public class MemberGroup
extends SystemGroup {
    private static final long serialVersionUID = 653102929460778599L;
    private Collection<MemberGroupAccountSettings> accountSettings;
    private Collection<MemberGroup> canViewProfileOfGroups;
    private Collection<MemberGroup> canViewAdsOfGroups;
    private Collection<AccountType> canViewInformationOf;
    private Collection<AccountFee> accountFees;
    private Collection<AdminGroup> managedByGroups;
    private Collection<CustomField> customFields;
    private Collection<TransactionFee> fromTransactionFees;
    private Collection<TransactionFee> toTransactionFees;
    private Collection<MemberGroup> canIssueCertificationToGroups;
    private Collection<MemberGroup> canBuyWithPaymentObligationsFromGroups;
    private Collection<Message.Type> defaultMailMessages;
    private Collection<Message.Type> smsMessages;
    private Collection<Message.Type> defaultSmsMessages;
    private Collection<Channel> channels;
    private Collection<Channel> defaultChannels;
    private Collection<Channel> requestPaymentByChannels;
    private Collection<GroupFilter> canViewGroupFilters;
    private Collection<BrokerGroup> possibleInitialGroupOf;
    private CardType cardType;
    private MemberGroupSettings memberSettings = new MemberGroupSettings();
    private String initialGroupShow;
    private boolean initialGroup;
    private boolean active;
    private boolean defaultAllowChargingSms;
    private boolean defaultAcceptFreeMailing;
    private boolean defaultAcceptPaidMailing;
    private RegistrationAgreement registrationAgreement;

    public Collection<AccountFee> getAccountFees() {
        return this.accountFees;
    }

    public Collection<MemberGroupAccountSettings> getAccountSettings() {
        return this.accountSettings;
    }

    public Collection<MemberAccountType> getAccountTypes() {
        HashSet<MemberAccountType> accountTypes = new HashSet<MemberAccountType>();
        if (this.accountSettings == null) {
            return null;
        }
        for (MemberGroupAccountSettings accountSetting : this.accountSettings) {
            accountTypes.add(accountSetting.getAccountType());
        }
        return accountTypes;
    }

    public Collection<MemberGroup> getCanBuyWithPaymentObligationsFromGroups() {
        return this.canBuyWithPaymentObligationsFromGroups;
    }

    public Collection<MemberGroup> getCanIssueCertificationToGroups() {
        return this.canIssueCertificationToGroups;
    }

    public Collection<MemberGroup> getCanViewAdsOfGroups() {
        return this.canViewAdsOfGroups;
    }

    public Collection<GroupFilter> getCanViewGroupFilters() {
        return this.canViewGroupFilters;
    }

    public Collection<AccountType> getCanViewInformationOf() {
        return this.canViewInformationOf;
    }

    public Collection<MemberGroup> getCanViewProfileOfGroups() {
        return this.canViewProfileOfGroups;
    }

    public CardType getCardType() {
        return this.cardType;
    }

    public Collection<Channel> getChannels() {
        return this.channels;
    }

    public Collection<CustomField> getCustomFields() {
        return this.customFields;
    }

    public Collection<Channel> getDefaultChannels() {
        return this.defaultChannels;
    }

    public Collection<Message.Type> getDefaultMailMessages() {
        return this.defaultMailMessages;
    }

    public Collection<Message.Type> getDefaultSmsMessages() {
        return this.defaultSmsMessages;
    }

    public Collection<TransactionFee> getFromTransactionFees() {
        return this.fromTransactionFees;
    }

    public String getInitialGroupShow() {
        return this.initialGroupShow;
    }

    public Collection<AdminGroup> getManagedByGroups() {
        return this.managedByGroups;
    }

    public MemberGroupSettings getMemberSettings() {
        if (this.memberSettings == null) {
            this.memberSettings = new MemberGroupSettings();
        }
        return this.memberSettings;
    }

    @Override
    public Group.Nature getNature() {
        return Group.Nature.MEMBER;
    }

    public Collection<BrokerGroup> getPossibleInitialGroupOf() {
        return this.possibleInitialGroupOf;
    }

    public RegistrationAgreement getRegistrationAgreement() {
        return this.registrationAgreement;
    }

    public Collection<Channel> getRequestPaymentByChannels() {
        return this.requestPaymentByChannels;
    }

    public Collection<Message.Type> getSmsMessages() {
        return this.smsMessages;
    }

    public Collection<TransactionFee> getToTransactionFees() {
        return this.toTransactionFees;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isBroker() {
        return false;
    }

    public boolean isDefaultAcceptFreeMailing() {
        return this.defaultAcceptFreeMailing;
    }

    public boolean isDefaultAcceptPaidMailing() {
        return this.defaultAcceptPaidMailing;
    }

    public boolean isDefaultAllowChargingSms() {
        return this.defaultAllowChargingSms;
    }

    public boolean isInitialGroup() {
        return this.initialGroup;
    }

    public void setAccountFees(Collection<AccountFee> accountFees) {
        this.accountFees = accountFees;
    }

    public void setAccountSettings(Collection<MemberGroupAccountSettings> settings) {
        this.accountSettings = settings;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setCanBuyWithPaymentObligationsFromGroups(Collection<MemberGroup> canBuyWithPaymentObligationsFromGroups) {
        this.canBuyWithPaymentObligationsFromGroups = canBuyWithPaymentObligationsFromGroups;
    }

    public void setCanIssueCertificationToGroups(Collection<MemberGroup> canIssueCertificationToGroups) {
        this.canIssueCertificationToGroups = canIssueCertificationToGroups;
    }

    public void setCanViewAdsOfGroups(Collection<MemberGroup> canViewAdsOfGroups) {
        this.canViewAdsOfGroups = canViewAdsOfGroups;
    }

    public void setCanViewGroupFilters(Collection<GroupFilter> canViewGroupFilters) {
        this.canViewGroupFilters = canViewGroupFilters;
    }

    public void setCanViewInformationOf(Collection<AccountType> canViewInformationOf) {
        this.canViewInformationOf = canViewInformationOf;
    }

    public void setCanViewProfileOfGroups(Collection<MemberGroup> canViewProfileOfGroups) {
        this.canViewProfileOfGroups = canViewProfileOfGroups;
    }

    public void setCardType(CardType cardType) {
        this.cardType = cardType;
    }

    public void setChannels(Collection<Channel> channels) {
        this.channels = channels;
    }

    public void setCustomFields(Collection<CustomField> customFields) {
        this.customFields = customFields;
    }

    public void setDefaultAcceptFreeMailing(boolean defaultAcceptFreeMailing) {
        this.defaultAcceptFreeMailing = defaultAcceptFreeMailing;
    }

    public void setDefaultAcceptPaidMailing(boolean defaultAcceptPaidMailing) {
        this.defaultAcceptPaidMailing = defaultAcceptPaidMailing;
    }

    public void setDefaultAllowChargingSms(boolean defaultAllowChargingSms) {
        this.defaultAllowChargingSms = defaultAllowChargingSms;
    }

    public void setDefaultChannels(Collection<Channel> defaultChannels) {
        this.defaultChannels = defaultChannels;
    }

    public void setDefaultMailMessages(Collection<Message.Type> defaultMailMessages) {
        this.defaultMailMessages = defaultMailMessages;
    }

    public void setDefaultSmsMessages(Collection<Message.Type> defaultSmsMessages) {
        this.defaultSmsMessages = defaultSmsMessages;
    }

    public void setFromTransactionFees(Collection<TransactionFee> fromTransactionFees) {
        this.fromTransactionFees = fromTransactionFees;
    }

    public void setInitialGroup(boolean initialGroup) {
        this.initialGroup = initialGroup;
    }

    public void setInitialGroupShow(String initialGroupShow) {
        this.initialGroupShow = initialGroupShow;
    }

    public void setManagedByGroups(Collection<AdminGroup> managedByGroups) {
        this.managedByGroups = managedByGroups;
    }

    public void setMemberSettings(MemberGroupSettings settings) {
        if (settings == null) {
            settings = new MemberGroupSettings();
        }
        this.memberSettings = settings;
    }

    public void setPossibleInitialGroupOf(Collection<BrokerGroup> possibleInitialGroupOf) {
        this.possibleInitialGroupOf = possibleInitialGroupOf;
    }

    public void setRegistrationAgreement(RegistrationAgreement registrationAgreement) {
        this.registrationAgreement = registrationAgreement;
    }

    public void setRequestPaymentByChannels(Collection<Channel> requestPaymentByChannels) {
        this.requestPaymentByChannels = requestPaymentByChannels;
    }

    public void setSmsMessages(Collection<Message.Type> smsMessages) {
        this.smsMessages = smsMessages;
    }

    public void setToTransactionFees(Collection<TransactionFee> toTransactionFees) {
        this.toTransactionFees = toTransactionFees;
    }

    public static enum Relationships implements Relationship
    {
        ACCOUNT_SETTINGS("accountSettings"),
        CAN_VIEW_PROFILE_OF_GROUPS("canViewProfileOfGroups"),
        CAN_VIEW_ADS_OF_GROUPS("canViewAdsOfGroups"),
        CAN_VIEW_INFORMATION_OF("canViewInformationOf"),
        ACCOUNT_FEES("accountFees"),
        MANAGED_BY_GROUPS("managedByGroups"),
        CUSTOM_FIELDS("customFields"),
        FROM_TRANSACTION_FEES("fromTransactionFees"),
        TO_TRANSACTION_FEES("toTransactionFees"),
        DEFAULT_MAIL_MESSAGES("defaultMailMessages"),
        SMS_MESSAGES("smsMessages"),
        DEFAULT_SMS_MESSAGES("defaultSmsMessages"),
        CHANNELS("channels"),
        DEFAULT_CHANNELS("defaultChannels"),
        REQUEST_PAYMENT_BY_CHANNELS("requestPaymentByChannels"),
        MEMBER_RECORD_TYPES("memberRecordTypes"),
        CAN_ISSUE_CERTIFICATION_TO_GROUPS("canIssueCertificationToGroups"),
        CAN_BUY_WITH_PAYMENT_OBLIGATIONS_FROM_GROUPS("canBuyWithPaymentObligationsFromGroups"),
        CAN_VIEW_GROUP_FILTERS("canViewGroupFilters"),
        POSSIBLE_INITIAL_GROUP_OF("possibleInitialGroupOf"),
        REGISTRATION_AGREEMENT("registrationAgreement"),
        CARD_TYPE("cardType");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

