/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.groups;

import java.math.BigDecimal;
import java.util.Set;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.utils.DataObject;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.TimePeriod;

public class MemberGroupSettings
extends DataObject {
    private static final long serialVersionUID = -5279193799739646568L;
    private Set<EmailValidation> emailValidation;
    private RangeConstraint pinLength = new RangeConstraint(4, 4);
    private int maxPinWrongTries = 3;
    private TimePeriod pinBlockTimeAfterMaxTries = new TimePeriod(1, TimePeriod.Field.DAYS);
    private TransferType smsChargeTransferType;
    private BigDecimal smsChargeAmount;
    private int smsFree = 0;
    private int smsAdditionalCharged = 1;
    private int smsShowFreeThreshold = 50;
    private TimePeriod smsAdditionalChargedPeriod = new TimePeriod(1, TimePeriod.Field.MONTHS);
    private String smsContextClassName;
    private boolean sendPasswordByEmail = true;
    private TimePeriod expireMembersAfter = null;
    private MemberGroup groupAfterExpiration = null;
    private int maxImagesPerMember = 3;
    private int maxAdsPerMember = 10;
    private boolean enablePermanentAds = true;
    private TimePeriod defaultAdPublicationTime = new TimePeriod(1, TimePeriod.Field.MONTHS);
    private TimePeriod maxAdPublicationTime = new TimePeriod(3, TimePeriod.Field.MONTHS);
    private ExternalAdPublication externalAdPublication = ExternalAdPublication.ENABLED;
    private int maxAdImagesPerMember = 3;
    private int maxAdDescriptionSize = 2048;
    private int maxSchedulingPayments = 36;
    private TimePeriod maxSchedulingPeriod = new TimePeriod(3, TimePeriod.Field.YEARS);
    private boolean viewLoansByGroup = true;
    private boolean repayLoanByGroup = true;
    private boolean allowMakePayment = false;
    private int maxPosSchedulingPayments = 6;
    private int numberOfCopies = 2;
    private int resultPageSize = 5;
    private boolean showPosWebPaymentDescription = false;

    public TimePeriod getDefaultAdPublicationTime() {
        return this.defaultAdPublicationTime;
    }

    public Set<EmailValidation> getEmailValidation() {
        return this.emailValidation;
    }

    public TimePeriod getExpireMembersAfter() {
        return this.expireMembersAfter;
    }

    public ExternalAdPublication getExternalAdPublication() {
        return this.externalAdPublication;
    }

    public MemberGroup getGroupAfterExpiration() {
        return this.groupAfterExpiration;
    }

    public int getMaxAdDescriptionSize() {
        return this.maxAdDescriptionSize;
    }

    public int getMaxAdImagesPerMember() {
        return this.maxAdImagesPerMember;
    }

    public TimePeriod getMaxAdPublicationTime() {
        return this.maxAdPublicationTime;
    }

    public int getMaxAdsPerMember() {
        return this.maxAdsPerMember;
    }

    public int getMaxImagesPerMember() {
        return this.maxImagesPerMember;
    }

    public int getMaxPinWrongTries() {
        return this.maxPinWrongTries;
    }

    public int getMaxPosSchedulingPayments() {
        return this.maxPosSchedulingPayments;
    }

    public int getMaxSchedulingPayments() {
        return this.maxSchedulingPayments;
    }

    public TimePeriod getMaxSchedulingPeriod() {
        return this.maxSchedulingPeriod;
    }

    public int getNumberOfCopies() {
        return this.numberOfCopies;
    }

    public TimePeriod getPinBlockTimeAfterMaxTries() {
        return this.pinBlockTimeAfterMaxTries;
    }

    public RangeConstraint getPinLength() {
        return this.pinLength;
    }

    public int getResultPageSize() {
        return this.resultPageSize;
    }

    public int getSmsAdditionalCharged() {
        return this.smsAdditionalCharged;
    }

    public TimePeriod getSmsAdditionalChargedPeriod() {
        return this.smsAdditionalChargedPeriod;
    }

    public BigDecimal getSmsChargeAmount() {
        return this.smsChargeAmount;
    }

    public TransferType getSmsChargeTransferType() {
        return this.smsChargeTransferType;
    }

    public String getSmsContextClassName() {
        return this.smsContextClassName;
    }

    public int getSmsFree() {
        return this.smsFree;
    }

    public int getSmsShowFreeThreshold() {
        return this.smsShowFreeThreshold;
    }

    public boolean isAllowMakePayment() {
        return this.allowMakePayment;
    }

    public boolean isAllowsMultipleScheduledPayments() {
        return this.isAllowsScheduledPayments() && this.maxSchedulingPayments > 1;
    }

    public boolean isAllowsScheduledPayments() {
        return this.maxSchedulingPayments > 0 && this.maxSchedulingPeriod != null && this.maxSchedulingPeriod.isValid();
    }

    public boolean isEnablePermanentAds() {
        return this.enablePermanentAds;
    }

    public boolean isRepayLoanByGroup() {
        return this.repayLoanByGroup;
    }

    public boolean isSendPasswordByEmail() {
        return this.sendPasswordByEmail;
    }

    public boolean isShowPosWebPaymentDescription() {
        return this.showPosWebPaymentDescription;
    }

    public boolean isViewLoansByGroup() {
        return this.viewLoansByGroup;
    }

    public void setAllowMakePayment(boolean allowMakePayment) {
        this.allowMakePayment = allowMakePayment;
    }

    public void setDefaultAdPublicationTime(TimePeriod defaultAdPublicationTime) {
        this.defaultAdPublicationTime = defaultAdPublicationTime;
    }

    public void setEmailValidation(Set<EmailValidation> emailValidation) {
        this.emailValidation = emailValidation;
    }

    public void setEnablePermanentAds(boolean enablePermanentAds) {
        this.enablePermanentAds = enablePermanentAds;
    }

    public void setExpireMembersAfter(TimePeriod expireMemberAfter) {
        this.expireMembersAfter = expireMemberAfter;
    }

    public void setExternalAdPublication(ExternalAdPublication externalAdPublication) {
        this.externalAdPublication = externalAdPublication;
    }

    public void setGroupAfterExpiration(MemberGroup groupAfterExpiration) {
        this.groupAfterExpiration = groupAfterExpiration;
    }

    public void setMaxAdDescriptionSize(int maxAdDescriptionSize) {
        this.maxAdDescriptionSize = maxAdDescriptionSize;
    }

    public void setMaxAdImagesPerMember(int maxAdImagesPerMember) {
        this.maxAdImagesPerMember = maxAdImagesPerMember;
    }

    public void setMaxAdPublicationTime(TimePeriod maxAdPublicationTime) {
        this.maxAdPublicationTime = maxAdPublicationTime;
    }

    public void setMaxAdsPerMember(int maxAdsPerMember) {
        this.maxAdsPerMember = maxAdsPerMember;
    }

    public void setMaxImagesPerMember(int maxImagesPerMember) {
        this.maxImagesPerMember = maxImagesPerMember;
    }

    public void setMaxPinWrongTries(int maxPinWrongTries) {
        this.maxPinWrongTries = maxPinWrongTries;
    }

    public void setMaxPosSchedulingPayments(int maxPosSchedulingPayments) {
        this.maxPosSchedulingPayments = maxPosSchedulingPayments;
    }

    public void setMaxSchedulingPayments(int maxSchedulingPayments) {
        this.maxSchedulingPayments = maxSchedulingPayments;
    }

    public void setMaxSchedulingPeriod(TimePeriod maxSchedulingPeriod) {
        this.maxSchedulingPeriod = maxSchedulingPeriod;
    }

    public void setNumberOfCopies(int numberOfCopies) {
        this.numberOfCopies = numberOfCopies;
    }

    public void setPinBlockTimeAfterMaxTries(TimePeriod pinBlockTimeAfterMaxTries) {
        this.pinBlockTimeAfterMaxTries = pinBlockTimeAfterMaxTries;
    }

    public void setPinLength(RangeConstraint pinLength) {
        this.pinLength = pinLength;
    }

    public void setRepayLoanByGroup(boolean repayLoansByGroup) {
        this.repayLoanByGroup = repayLoansByGroup;
    }

    public void setResultPageSize(int resultPageSize) {
        this.resultPageSize = resultPageSize;
    }

    public void setSendPasswordByEmail(boolean sendPasswordByMail) {
        this.sendPasswordByEmail = sendPasswordByMail;
    }

    public void setShowPosWebPaymentDescription(boolean showPosWebPaymentDescription) {
        this.showPosWebPaymentDescription = showPosWebPaymentDescription;
    }

    public void setSmsAdditionalCharged(int smsAdditionalCharged) {
        this.smsAdditionalCharged = smsAdditionalCharged;
    }

    public void setSmsAdditionalChargedPeriod(TimePeriod smsAdditionalChargedPeriod) {
        this.smsAdditionalChargedPeriod = smsAdditionalChargedPeriod;
    }

    public void setSmsChargeAmount(BigDecimal smsChargeAmount) {
        this.smsChargeAmount = smsChargeAmount;
    }

    public void setSmsChargeTransferType(TransferType smsChargeTransferType) {
        this.smsChargeTransferType = smsChargeTransferType;
    }

    public void setSmsContextClassName(String smsContextClassName) {
        this.smsContextClassName = smsContextClassName;
    }

    public void setSmsFree(int smsFree) {
        this.smsFree = smsFree;
    }

    public void setSmsShowFreeThreshold(int smsShowFreeThreshold) {
        this.smsShowFreeThreshold = smsShowFreeThreshold;
    }

    public void setViewLoansByGroup(boolean viewLoansByGroup) {
        this.viewLoansByGroup = viewLoansByGroup;
    }

    public static enum ExternalAdPublication implements StringValuedEnum
    {
        ALLOW_CHOICE("C"),
        ENABLED("E"),
        DISABLED("D");

        private final String value;

        private ExternalAdPublication(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum EmailValidation implements StringValuedEnum
    {
        USER("U"),
        ADMIN("A"),
        BROKER("B"),
        WEB_SERVICE("W");

        private final String value;

        private EmailValidation(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

