/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.groups;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.BasicGroupSettings;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Member;

public class OperatorGroup
extends Group {
    private static final long serialVersionUID = 6092174598805612471L;
    private Member member;
    private Map<TransferType, BigDecimal> maxAmountPerDayByTransferType;
    private Collection<AccountType> canViewInformationOf;

    @Override
    public BasicGroupSettings getBasicSettings() {
        return this.member.getGroup().getBasicSettings();
    }

    public Collection<AccountType> getCanViewInformationOf() {
        return this.canViewInformationOf;
    }

    public Map<TransferType, BigDecimal> getMaxAmountPerDayByTransferType() {
        return this.maxAmountPerDayByTransferType;
    }

    public Member getMember() {
        return this.member;
    }

    @Override
    public Group.Nature getNature() {
        return Group.Nature.OPERATOR;
    }

    public void setCanViewInformationOf(Collection<AccountType> canViewInformationOf) {
        this.canViewInformationOf = canViewInformationOf;
    }

    public void setMaxAmountPerDayByTransferType(Map<TransferType, BigDecimal> maxAmountPerDayByTransferType) {
        this.maxAmountPerDayByTransferType = maxAmountPerDayByTransferType;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public static enum Relationships implements Relationship
    {
        MEMBER("member"),
        MAX_AMOUNT_PER_DAY_BY_TRANSFER_TYPE("maxAmountPerDayByTransferType"),
        CAN_VIEW_INFORMATION_OF("canViewInformationOf");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

