/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.groups;

import java.util.ArrayList;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;

public abstract class SystemGroup
extends Group {
    private static final long serialVersionUID = 1L;
    private String rootUrl;
    private String loginPageName;
    private String containerUrl;
    private Collection<Document> documents;
    private Collection<MessageCategory> messageCategories;
    private Collection<TransferType> chargebackTransferTypes;

    public void addDocument(Document document) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(document);
    }

    public Collection<TransferType> getChargebackTransferTypes() {
        return this.chargebackTransferTypes;
    }

    public String getContainerUrl() {
        return this.containerUrl;
    }

    public Collection<Document> getDocuments() {
        return this.documents;
    }

    public String getLoginPageName() {
        return this.loginPageName;
    }

    public Collection<MessageCategory> getMessageCategories() {
        return this.messageCategories;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public void setChargebackTransferTypes(Collection<TransferType> chargebackTransferTypes) {
        this.chargebackTransferTypes = chargebackTransferTypes;
    }

    public void setContainerUrl(String containerUrl) {
        this.containerUrl = containerUrl;
    }

    public void setDocuments(Collection<Document> documents) {
        this.documents = documents;
    }

    public void setLoginPageName(String loginPageName) {
        this.loginPageName = loginPageName;
    }

    public void setMessageCategories(Collection<MessageCategory> messageCategories) {
        this.messageCategories = messageCategories;
    }

    public void setRootUrl(String rootUrl) {
        this.rootUrl = rootUrl;
    }

    public static enum Relationships implements Relationship
    {
        DOCUMENTS("documents"),
        MESSAGE_CATEGORIES("messageCategories"),
        CHARGEBACK_TRANSFER_TYPES("chargebackTransferTypes");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

