/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.infotexts;

import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Set;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.utils.Period;
import org.apache.commons.lang.StringUtils;

public class InfoText
extends Entity {
    private static final long serialVersionUID = 1L;
    private String subject;
    private String body;
    private boolean enabled;
    private Period validity;
    private Set<String> aliases;

    public void addAlias(String alias) {
        if (this.aliases == null) {
            this.aliases = new LinkedHashSet<String>();
        }
        this.aliases.add(alias);
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public String getAliasesString() {
        return StringUtils.join(this.aliases, (String)",");
    }

    public String getBody() {
        return this.body;
    }

    public String getSubject() {
        return this.subject;
    }

    public Period getValidity() {
        return this.validity;
    }

    public boolean isActive() {
        if (this.enabled) {
            if (this.validity == null) {
                return true;
            }
            return this.validity.includes(Calendar.getInstance());
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setAliases(Set<String> aliases) {
        this.aliases = aliases;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setValidity(Period validity) {
        this.validity = validity;
    }

    @Override
    public String toString() {
        return this.getId() + " - InfoText - " + this.getAliases();
    }
}

