/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.members;

import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Indexable;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupHistoryLog;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.entities.members.remarks.Remark;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.ElementVO;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public abstract class Element
extends Entity
implements Indexable {
    private static final long serialVersionUID = 5024785667579155058L;
    private Calendar creationDate;
    private String email;
    private Group group;
    private String name;
    private User user;
    private Collection<GroupHistoryLog> groupHistoryLogs;
    private Collection<Remark> remarks;
    private Collection<MemberRecord> memberRecords;

    public abstract AccountOwner getAccountOwner();

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public String getEmail() {
        return this.email;
    }

    public Group getGroup() {
        return this.group;
    }

    public Collection<GroupHistoryLog> getGroupHistoryLogs() {
        return this.groupHistoryLogs;
    }

    public Collection<MemberRecord> getMemberRecords() {
        return this.memberRecords;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public abstract Nature getNature();

    public Collection<Remark> getRemarks() {
        return this.remarks;
    }

    public User getUser() {
        return this.user;
    }

    public String getUsername() {
        return this.user == null ? null : this.user.getUsername();
    }

    public boolean isActive() {
        return this.group == null ? false : !this.group.isRemoved();
    }

    @Override
    public final ElementVO readOnlyView() {
        return new ElementVO(this.getId(), this.getName(), this.getUsername(), this.getGroup().getId(), this.getNature());
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public void setGroupHistoryLogs(Collection<GroupHistoryLog> groupHistoryLogs) {
        this.groupHistoryLogs = groupHistoryLogs;
    }

    public void setMemberRecords(Collection<MemberRecord> memberRecords) {
        this.memberRecords = memberRecords;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRemarks(Collection<Remark> remarks) {
        this.remarks = remarks;
    }

    public void setUser(User user) {
        this.user = user;
        if (user != null) {
            user.setElement(this);
        }
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.getUsername() + " (" + this.name + ")";
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        variables.put("login", this.getUsername());
        variables.put("name", this.name);
        variables.put("email", this.email);
        variables.put("member", this.name);
    }

    public static enum Relationships implements Relationship
    {
        GROUP("group"),
        USER("user"),
        GROUP_HISTORY_LOGS("groupHistoryLogs"),
        MEMBER_RECORDS("memberRecords"),
        REMARKS("remarks");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Nature implements StringValuedEnum
    {
        ADMIN("A"),
        MEMBER("M"),
        OPERATOR("O");

        private final String value;

        private Nature(String value) {
            this.value = value;
        }

        public Class<? extends Element> getElementClass() {
            switch (this) {
                case ADMIN: {
                    return Administrator.class;
                }
                case MEMBER: {
                    return Member.class;
                }
                case OPERATOR: {
                    return Operator.class;
                }
            }
            throw new IllegalStateException("Unknown element nature: " + this);
        }

        public Class<? extends Element> getType() {
            return this == ADMIN ? Administrator.class : Member.class;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

