/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.members;

import java.util.Calendar;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.cards.Card;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroup;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.images.MemberImage;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Contact;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.RegisteredMember;
import nl.strohalm.cyclos.entities.members.RegistrationAgreementLog;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.entities.members.preferences.NotificationPreference;
import org.apache.commons.collections.CollectionUtils;

public class Member
extends Element
implements RegisteredMember,
AccountOwner {
    private static final long serialVersionUID = -1702931176820698931L;
    private Calendar activationDate;
    private Collection<Ad> ads;
    private Member broker;
    private boolean hideEmail;
    private Collection<Member> brokeredMembers;
    private Collection<Brokering> brokerings;
    private Collection<Brokering> brokeringsAsBrokered;
    private Collection<Contact> contacts;
    private Collection<MemberCustomFieldValue> customValues;
    private Collection<MemberImage> images;
    private Collection<LoanGroup> loanGroups;
    private Collection<MemberAlert> alerts;
    private Collection<NotificationPreference> notificationPreferences;
    private Collection<Channel> channels;
    private Collection<RegistrationAgreementLog> registrationAgreementLogs;
    private Collection<Card> cards;
    private Collection<MemberPos> posDevices;

    @Override
    public AccountOwner getAccountOwner() {
        return this;
    }

    public Calendar getActivationDate() {
        return this.activationDate;
    }

    public Collection<Ad> getAds() {
        return this.ads;
    }

    public Collection<MemberAlert> getAlerts() {
        return this.alerts;
    }

    @Override
    public Member getBroker() {
        return this.broker;
    }

    public Collection<Member> getBrokeredMembers() {
        return this.brokeredMembers;
    }

    public Collection<Brokering> getBrokerings() {
        return this.brokerings;
    }

    public Collection<Brokering> getBrokeringsAsBrokered() {
        return this.brokeringsAsBrokered;
    }

    public Collection<Card> getCards() {
        return this.cards;
    }

    public Collection<Channel> getChannels() {
        return this.channels;
    }

    public Collection<Contact> getContacts() {
        return this.contacts;
    }

    @Override
    public Class<MemberCustomField> getCustomFieldClass() {
        return MemberCustomField.class;
    }

    @Override
    public Class<MemberCustomFieldValue> getCustomFieldValueClass() {
        return MemberCustomFieldValue.class;
    }

    @Override
    public Collection<MemberCustomFieldValue> getCustomValues() {
        return this.customValues;
    }

    public Collection<MemberImage> getImages() {
        return this.images;
    }

    public Collection<LoanGroup> getLoanGroups() {
        return this.loanGroups;
    }

    @Override
    public MemberGroup getMemberGroup() {
        return (MemberGroup)super.getGroup();
    }

    public MemberUser getMemberUser() {
        return (MemberUser)super.getUser();
    }

    @Override
    public Element.Nature getNature() {
        return Element.Nature.MEMBER;
    }

    public Collection<NotificationPreference> getNotificationPreferences() {
        return this.notificationPreferences;
    }

    public Collection<MemberPos> getPosDevices() {
        return this.posDevices;
    }

    public Collection<RegistrationAgreementLog> getRegistrationAgreementLogs() {
        return this.registrationAgreementLogs;
    }

    @Override
    public boolean isActive() {
        return this.getMemberGroup().isActive() && this.activationDate != null;
    }

    public boolean isHasImages() {
        return CollectionUtils.isNotEmpty(this.getImages());
    }

    @Override
    public boolean isHideEmail() {
        return this.hideEmail;
    }

    public void setActivationDate(Calendar activationDate) {
        this.activationDate = activationDate;
    }

    public void setAds(Collection<Ad> ads) {
        this.ads = ads;
    }

    public void setAlerts(Collection<MemberAlert> alerts) {
        this.alerts = alerts;
    }

    public void setBroker(Member broker) {
        this.broker = broker;
    }

    public void setBrokeredMembers(Collection<Member> brokeredMembers) {
        this.brokeredMembers = brokeredMembers;
    }

    public void setBrokerings(Collection<Brokering> brokerings) {
        this.brokerings = brokerings;
    }

    public void setBrokeringsAsBrokered(Collection<Brokering> brokeringsAsBrokered) {
        this.brokeringsAsBrokered = brokeringsAsBrokered;
    }

    public void setCards(Collection<Card> cards) {
        this.cards = cards;
    }

    public void setChannels(Collection<Channel> channels) {
        this.channels = channels;
    }

    public void setContacts(Collection<Contact> contacts) {
        this.contacts = contacts;
    }

    @Override
    public void setCustomValues(Collection<MemberCustomFieldValue> customValues) {
        this.customValues = customValues;
    }

    public void setHideEmail(boolean hideEmail) {
        this.hideEmail = hideEmail;
    }

    public void setImages(Collection<MemberImage> images) {
        this.images = images;
    }

    public void setLoanGroups(Collection<LoanGroup> loanGroups) {
        this.loanGroups = loanGroups;
    }

    public void setNotificationPreferences(Collection<NotificationPreference> notificationPreferences) {
        this.notificationPreferences = notificationPreferences;
    }

    public void setPosDevices(Collection<MemberPos> posDevices) {
        this.posDevices = posDevices;
    }

    public void setRegistrationAgreementLogs(Collection<RegistrationAgreementLog> registrationAgreementLogs) {
        this.registrationAgreementLogs = registrationAgreementLogs;
    }

    public static enum Relationships implements Relationship
    {
        ADS("ads"),
        BROKER("broker"),
        BROKERED_MEMBERS("brokeredMembers"),
        BROKERINGS("brokerings"),
        BROKERINGS_AS_BROKERED("brokeringsAsBrokered"),
        CUSTOM_VALUES("customValues"),
        IMAGES("images"),
        LOAN_GROUPS("loanGroups"),
        MESSAGES("messages"),
        REFERENCES_FROM("referencesFrom"),
        REFERENCES_TO("referencesTo"),
        REMARKS("remarks"),
        CONTACTS("contacts"),
        ALERTS("alerts"),
        NOTIFICATION_PREFERENCES("notificationPreferences"),
        CHANNELS("channels"),
        REGISTRATION_AGREEMENT_LOGS("registrationAgreementLogs");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

