/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.members;

import java.util.HashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.DataObject;
import org.apache.commons.collections.MapUtils;

public class MemberTransactionSummaryReportData
extends DataObject {
    private static final long serialVersionUID = 6613220701881304322L;
    private Member member;
    private Map<PaymentFilter, TransactionSummaryVO> debits;
    private Map<PaymentFilter, TransactionSummaryVO> credits;

    public void addCredits(PaymentFilter paymentFilter, TransactionSummaryVO transactions) {
        if (transactions == null || transactions.getCount() == 0) {
            return;
        }
        if (this.credits == null) {
            this.credits = new HashMap<PaymentFilter, TransactionSummaryVO>();
        }
        this.credits.put(paymentFilter, transactions);
    }

    public void addDebits(PaymentFilter paymentFilter, TransactionSummaryVO transactions) {
        if (transactions == null || transactions.getCount() == 0) {
            return;
        }
        if (this.debits == null) {
            this.debits = new HashMap<PaymentFilter, TransactionSummaryVO>();
        }
        this.debits.put(paymentFilter, transactions);
    }

    public Map<PaymentFilter, TransactionSummaryVO> getCredits() {
        return this.credits;
    }

    public Map<PaymentFilter, TransactionSummaryVO> getDebits() {
        return this.debits;
    }

    public Member getMember() {
        return this.member;
    }

    public boolean isHasData() {
        return MapUtils.isNotEmpty(this.credits) || MapUtils.isNotEmpty(this.debits);
    }

    public void setCredits(Map<PaymentFilter, TransactionSummaryVO> credits) {
        this.credits = credits;
    }

    public void setDebits(Map<PaymentFilter, TransactionSummaryVO> debits) {
        this.debits = debits;
    }

    public void setMember(Member member) {
        this.member = member;
    }
}

