/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.members;

import java.util.Calendar;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.members.Reference;

public class TransactionFeedback
extends Reference {
    private static final long serialVersionUID = -2759397836741489295L;
    private Transfer transfer;
    private ScheduledPayment scheduledPayment;
    private String replyComments;
    private Calendar replyCommentsDate;
    private String adminComments;
    private Calendar adminCommentsDate;

    public String getAdminComments() {
        return this.adminComments;
    }

    public Calendar getAdminCommentsDate() {
        return this.adminCommentsDate;
    }

    @Override
    public Reference.Nature getNature() {
        return Reference.Nature.TRANSACTION;
    }

    public Payment getPayment() {
        return this.transfer == null ? this.scheduledPayment : this.transfer;
    }

    public String getReplyComments() {
        return this.replyComments;
    }

    public Calendar getReplyCommentsDate() {
        return this.replyCommentsDate;
    }

    public ScheduledPayment getScheduledPayment() {
        return this.scheduledPayment;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public void setAdminComments(String adminComments) {
        this.adminComments = adminComments;
    }

    public void setAdminCommentsDate(Calendar adminCommentsDate) {
        this.adminCommentsDate = adminCommentsDate;
    }

    public void setPayment(Payment payment) {
        if (payment instanceof Transfer) {
            this.transfer = (Transfer)payment;
            this.scheduledPayment = null;
        } else if (payment instanceof ScheduledPayment) {
            this.scheduledPayment = (ScheduledPayment)payment;
            this.transfer = null;
        } else {
            this.transfer = null;
            this.scheduledPayment = null;
        }
    }

    public void setReplyComments(String replyComments) {
        this.replyComments = replyComments;
    }

    public void setReplyCommentsDate(Calendar replyCommentsDate) {
        this.replyCommentsDate = replyCommentsDate;
    }

    public void setScheduledPayment(ScheduledPayment scheduledPayment) {
        this.scheduledPayment = scheduledPayment;
    }

    public void setTransfer(Transfer transfer) {
        this.transfer = transfer;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.getLevel() + " for " + (this.transfer == null ? this.scheduledPayment : this.transfer);
    }

    public static enum Relationships implements Relationship
    {
        TRANSFER("transfer"),
        SCHEDULED_PAYMENT("scheduledPayment");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

