/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.members.brokerings;

import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public class BrokerCommissionContract
extends Entity {
    private static final long serialVersionUID = -4791497274620475610L;
    private Brokering brokering;
    private BrokerCommission brokerCommission;
    private Period period;
    private Amount amount;
    private Status status;
    private Status statusBeforeSuspension;
    private Element cancelledBy;

    public Amount getAmount() {
        return this.amount;
    }

    public BrokerCommission getBrokerCommission() {
        return this.brokerCommission;
    }

    public Brokering getBrokering() {
        return this.brokering;
    }

    public Element getCancelledBy() {
        return this.cancelledBy;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Status getStatus() {
        return this.status;
    }

    public Status getStatusBeforeSuspension() {
        return this.statusBeforeSuspension;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public void setBrokerCommission(BrokerCommission brokerCommission) {
        this.brokerCommission = brokerCommission;
    }

    public void setBrokering(Brokering brokering) {
        this.brokering = brokering;
    }

    public void setCancelledBy(Element cancelledBy) {
        this.cancelledBy = cancelledBy;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setStatusBeforeSuspension(Status statusBeforeSuspension) {
        this.statusBeforeSuspension = statusBeforeSuspension;
    }

    @Override
    public String toString() {
        return "" + this.getId();
    }

    @Override
    protected void appendVariableValues(Map<String, Object> variables, LocalSettings localSettings) {
        variables.put("broker", this.getBrokering().getBroker().getName());
        variables.put("broker_login", this.getBrokering().getBroker().getUsername());
        variables.put("member", this.getBrokering().getBrokered().getName());
        variables.put("member_login", this.getBrokering().getBrokered().getUsername());
        variables.put("start_date", localSettings.getRawDateConverter().toString(this.getPeriod().getBegin()));
        variables.put("end_date", localSettings.getRawDateConverter().toString(this.getPeriod().getEnd()));
        variables.put("amount", localSettings.getAmountConverter().toString(this.getAmount()));
    }

    public static enum Status implements StringValuedEnum
    {
        PENDING("P"),
        ACCEPTED("T"),
        DENIED("D"),
        EXPIRED("E"),
        ACTIVE("A"),
        CLOSED("L"),
        SUSPENDED("S"),
        CANCELLED("C");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Relationships implements Relationship
    {
        BROKERING("brokering"),
        BROKER_COMMISSION("brokerCommission");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

