/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.members.imports;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.members.imports.ImportedMemberRecord;
import nl.strohalm.cyclos.entities.members.imports.MemberImport;
import nl.strohalm.cyclos.utils.CustomFieldsContainer;
import nl.strohalm.cyclos.utils.StringValuedEnum;

public class ImportedMember
extends Entity
implements CustomFieldsContainer<MemberCustomField, MemberCustomFieldValue> {
    private static final long serialVersionUID = -4080042034080488479L;
    private MemberImport _import;
    private Status status;
    private String errorArgument1;
    private String errorArgument2;
    private String name;
    private String salt;
    private String username;
    private String password;
    private String email;
    private Integer lineNumber;
    private Calendar creationDate;
    private BigDecimal creditLimit;
    private BigDecimal upperCreditLimit;
    private BigDecimal initialBalance;
    private Collection<MemberCustomFieldValue> customValues;
    private Collection<ImportedMemberRecord> records;

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public BigDecimal getCreditLimit() {
        return this.creditLimit;
    }

    @Override
    public Class<MemberCustomField> getCustomFieldClass() {
        return MemberCustomField.class;
    }

    @Override
    public Class<MemberCustomFieldValue> getCustomFieldValueClass() {
        return MemberCustomFieldValue.class;
    }

    @Override
    public Collection<MemberCustomFieldValue> getCustomValues() {
        return this.customValues;
    }

    public String getEmail() {
        return this.email;
    }

    public String getErrorArgument1() {
        return this.errorArgument1;
    }

    public String getErrorArgument2() {
        return this.errorArgument2;
    }

    public MemberImport getImport() {
        return this._import;
    }

    public BigDecimal getInitialBalance() {
        return this.initialBalance;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Collection<ImportedMemberRecord> getRecords() {
        return this.records;
    }

    public String getSalt() {
        return this.salt;
    }

    public Status getStatus() {
        return this.status;
    }

    public BigDecimal getUpperCreditLimit() {
        return this.upperCreditLimit;
    }

    public String getUsername() {
        return this.username;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public void setCreditLimit(BigDecimal creditLimit) {
        this.creditLimit = creditLimit;
    }

    @Override
    public void setCustomValues(Collection<MemberCustomFieldValue> customValues) {
        this.customValues = customValues;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setErrorArgument1(String errorArgument) {
        this.errorArgument1 = errorArgument;
    }

    public void setErrorArgument2(String errorArgument2) {
        this.errorArgument2 = errorArgument2;
    }

    public void setImport(MemberImport _import) {
        this._import = _import;
    }

    public void setInitialBalance(BigDecimal initialBalance) {
        this.initialBalance = initialBalance;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRecords(Collection<ImportedMemberRecord> records) {
        this.records = records;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setStatus(Status status) {
        this.status = status;
        if (status != null && status != Status.SUCCESS) {
            this.creditLimit = BigDecimal.ZERO;
            this.initialBalance = null;
            this.upperCreditLimit = null;
        }
    }

    public void setUpperCreditLimit(BigDecimal upperCreditLimit) {
        this.upperCreditLimit = upperCreditLimit;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.getName() + " (" + this.getUsername() + ")";
    }

    public static enum Status implements StringValuedEnum
    {
        SUCCESS,
        MISSING_NAME,
        MISSING_USERNAME,
        INVALID_USERNAME,
        USERNAME_ALREADY_IN_USE,
        MISSING_EMAIL,
        INVALID_EMAIL,
        INVALID_CREATION_DATE,
        MISSING_CUSTOM_FIELD,
        INVALID_CUSTOM_FIELD,
        INVALID_BALANCE,
        BALANCE_LOWER_THAN_CREDIT_LIMIT,
        BALANCE_UPPER_THAN_CREDIT_LIMIT,
        INVALID_CREDIT_LIMIT,
        INVALID_UPPER_CREDIT_LIMIT,
        INVALID_RECORD_TYPE,
        INVALID_RECORD_TYPE_FIELD,
        MISSING_RECORD_FIELD,
        INVALID_RECORD_FIELD,
        UNKNOWN_ERROR,
        INVALID_CUSTOM_FIELD_VALUE_UNIQUE,
        INVALID_CUSTOM_FIELD_VALUE_MAX_LENGTH,
        INVALID_CUSTOM_FIELD_VALUE_MIN_LENGTH;


        @Override
        public String getValue() {
            return this.name();
        }
    }

    public static enum Relationships implements Relationship
    {
        IMPORT("import"),
        CUSTOM_VALUES("customValues"),
        RECORDS("records");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

