/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.members.messages;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.MessageBox;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import org.apache.commons.collections.CollectionUtils;

public class Message
extends Entity {
    private static final long serialVersionUID = -2421844991813820706L;
    private Calendar date;
    private Member fromMember;
    private Member toMember;
    private Direction direction;
    private String subject;
    private String body;
    private MessageCategory category;
    private Type type;
    private boolean read;
    private Calendar removedAt;
    private boolean replied;
    private boolean html;
    private boolean emailSent;
    private List<MemberGroup> toGroups;

    public String getBody() {
        return this.body;
    }

    public MessageCategory getCategory() {
        return this.category;
    }

    public Calendar getDate() {
        return this.date;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Member getFromMember() {
        return this.fromMember;
    }

    public MessageBox getMessageBox() {
        if (this.direction == null) {
            throw new IllegalStateException("Cannot determine message box - direction is null");
        }
        if (this.removedAt != null) {
            return MessageBox.TRASH;
        }
        if (this.direction == Direction.INCOMING) {
            return MessageBox.INBOX;
        }
        return MessageBox.SENT;
    }

    public Member getOwner() {
        if (this.direction == null) {
            throw new IllegalStateException("Cannot determine message owner - direction is null");
        }
        switch (this.direction) {
            case INCOMING: {
                return this.toMember;
            }
            case OUTGOING: {
                return this.fromMember;
            }
        }
        return null;
    }

    public Member getRelatedMember() {
        if (this.direction == null) {
            throw new IllegalStateException("Cannot determine message related member - direction is null");
        }
        switch (this.direction) {
            case INCOMING: {
                return this.fromMember;
            }
            case OUTGOING: {
                return this.toMember;
            }
        }
        return null;
    }

    public Calendar getRemovedAt() {
        return this.removedAt;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<MemberGroup> getToGroups() {
        return this.toGroups;
    }

    public Member getToMember() {
        return this.toMember;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isBulk() {
        return this.type == Type.FROM_ADMIN_TO_GROUP;
    }

    public boolean isEmailSent() {
        return this.emailSent;
    }

    public boolean isFromAdministration() {
        return !this.isFromSystem() && !this.isFromAMember();
    }

    public boolean isFromAMember() {
        return this.fromMember != null;
    }

    public boolean isFromSystem() {
        return this.type != null && this.type.getRootType() == RootType.SYSTEM;
    }

    public boolean isHtml() {
        return this.html;
    }

    public boolean isRead() {
        return this.read;
    }

    public boolean isRemoved() {
        return this.removedAt != null;
    }

    public boolean isReplied() {
        return this.replied;
    }

    public boolean isToAdministration() {
        return this.isFromAMember() && !this.isToAMember() && this.type == Type.FROM_MEMBER;
    }

    public boolean isToAGroup() {
        return CollectionUtils.isNotEmpty(this.toGroups);
    }

    public boolean isToAMember() {
        return this.toMember != null;
    }

    public boolean isToBrokeredMembers() {
        return this.isBulk() && this.isFromAMember();
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setCategory(MessageCategory category) {
        this.category = category;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setEmailSent(boolean emailSent) {
        this.emailSent = emailSent;
    }

    public void setFromMember(Member fromMember) {
        this.fromMember = fromMember;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public void setRemovedAt(Calendar removedAt) {
        this.removedAt = removedAt;
    }

    public void setReplied(boolean replied) {
        this.replied = replied;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setToGroups(List<MemberGroup> toGroups) {
        this.toGroups = toGroups;
    }

    public void setToMember(Member toMember) {
        this.toMember = toMember;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + this.subject;
    }

    public static enum Type implements StringValuedEnum
    {
        FROM_MEMBER(RootType.MEMBER, "mbr"),
        FROM_ADMIN_TO_MEMBER(RootType.ADMIN, "a2m"),
        FROM_ADMIN_TO_GROUP(RootType.ADMIN, "a2g"),
        ACCESS(RootType.SYSTEM, "acs"),
        ACCOUNT(RootType.SYSTEM, "act"),
        BROKERING(RootType.SYSTEM, "brk"),
        PAYMENT(RootType.SYSTEM, "pmt"),
        EXTERNAL_PAYMENT(RootType.SYSTEM, "ept"),
        LOAN(RootType.SYSTEM, "loa"),
        AD_EXPIRATION(RootType.SYSTEM, "ade"),
        AD_INTEREST(RootType.SYSTEM, "adi"),
        INVOICE(RootType.SYSTEM, "inv"),
        REFERENCE(RootType.SYSTEM, "ref"),
        TRANSACTION_FEEDBACK(RootType.SYSTEM, "tfb"),
        CERTIFICATION(RootType.SYSTEM, "cer"),
        GUARANTEE(RootType.SYSTEM, "gua"),
        PAYMENT_OBLIGATION(RootType.SYSTEM, "pob");

        private final String value;
        private final RootType rootType;

        public static List<Type> listByRootType(RootType rootType) {
            ArrayList<Type> types = new ArrayList<Type>();
            if (rootType != null) {
                for (Type type : Type.values()) {
                    if (type.getRootType() != rootType) continue;
                    types.add(type);
                }
            }
            return types;
        }

        private Type(RootType rootType, String value) {
            this.rootType = rootType;
            this.value = value;
        }

        public RootType getRootType() {
            return this.rootType;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean isMass() {
            return this == FROM_ADMIN_TO_GROUP || this == BROKERING;
        }
    }

    public static enum RootType {
        MEMBER,
        ADMIN,
        SYSTEM;

    }

    public static enum Relationships implements Relationship
    {
        CATEGORY("category"),
        FROM_MEMBER("fromMember"),
        TO_MEMBER("toMember"),
        TO_GROUPS("toGroups"),
        PENDING_TO_SEND("pendingToSend");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum Direction implements StringValuedEnum
    {
        INCOMING("I"),
        OUTGOING("O");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public Direction invert() {
            if (this == INCOMING) {
                return OUTGOING;
            }
            return INCOMING;
        }
    }
}

