/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.reports;

public class StatisticalNumber
extends Number
implements Comparable<StatisticalNumber> {
    private static final long serialVersionUID = -7277480165783349984L;
    private final Double value;
    private Double error;
    private byte precision;
    private Double lowerBound;
    private Double upperBound;
    private boolean pvalue;
    private boolean percentage;
    private boolean isNull;

    public static StatisticalNumber createNullPvalue() {
        StatisticalNumber sn = new StatisticalNumber(0.0);
        sn.isNull = true;
        sn.pvalue = true;
        return sn;
    }

    public static StatisticalNumber createPercentage(Double value) {
        StatisticalNumber statisticalNumber = null;
        if (value == null) {
            statisticalNumber = new StatisticalNumber(0.0);
            statisticalNumber.isNull = true;
        } else {
            statisticalNumber = new StatisticalNumber(value);
        }
        statisticalNumber.percentage = true;
        return statisticalNumber;
    }

    public static StatisticalNumber createPercentage(Number value1, Number value2) {
        StatisticalNumber sn2;
        StatisticalNumber sn1;
        if (value1 instanceof StatisticalNumber && ((sn1 = (StatisticalNumber)value1).getValue() == null || sn1.isNull)) {
            return StatisticalNumber.createPercentage(null);
        }
        if (value2 instanceof StatisticalNumber && ((sn2 = (StatisticalNumber)value2).getValue() == null || sn2.isNull)) {
            return StatisticalNumber.createPercentage(null);
        }
        if (value1 == null || value2 == null) {
            return StatisticalNumber.createPercentage(null);
        }
        if (value2.floatValue() == 0.0f) {
            return StatisticalNumber.createPercentage(null);
        }
        double percentage = 100.0f * (value1.floatValue() - value2.floatValue()) / value2.floatValue();
        return StatisticalNumber.createPercentage(percentage);
    }

    public static StatisticalNumber createPvalue(double value) {
        StatisticalNumber statisticalNumber = new StatisticalNumber(value);
        statisticalNumber.pvalue = true;
        statisticalNumber.precision = (byte)3;
        return statisticalNumber;
    }

    public static Number scale(Number oldNumber, double scaleFactor) {
        Number newNumber;
        if (oldNumber == null) {
            return null;
        }
        if (oldNumber instanceof StatisticalNumber) {
            StatisticalNumber statisticalOldNumber = (StatisticalNumber)oldNumber;
            if (statisticalOldNumber.isNull) {
                return new StatisticalNumber();
            }
            if (statisticalOldNumber.pvalue | statisticalOldNumber.percentage) {
                return oldNumber;
            }
            double newValue = statisticalOldNumber.doubleValue() / scaleFactor;
            if (statisticalOldNumber.error == null && statisticalOldNumber.lowerBound != null) {
                Double newLower = statisticalOldNumber.lowerBound / scaleFactor;
                Double newUpper = statisticalOldNumber.upperBound / scaleFactor;
                newNumber = new StatisticalNumber(newValue, newLower, newUpper, statisticalOldNumber.precision);
            } else {
                Double newError = statisticalOldNumber.error == null ? null : Double.valueOf(statisticalOldNumber.error / scaleFactor);
                newNumber = new StatisticalNumber(newValue, newError, statisticalOldNumber.precision);
            }
        } else {
            newNumber = oldNumber.doubleValue() / scaleFactor;
        }
        return newNumber;
    }

    public StatisticalNumber() {
        this.value = null;
        this.isNull = true;
    }

    public StatisticalNumber(double value) {
        this.value = new Double(value);
    }

    public StatisticalNumber(double value, byte precision) {
        this.value = new Double(value);
        this.precision = precision;
    }

    public StatisticalNumber(double value, Double error, byte precision) {
        this.value = new Double(value);
        this.error = error;
        this.precision = precision;
    }

    public StatisticalNumber(double value, Double lowerBound, Double upperBound, byte precision) {
        if (lowerBound == null || upperBound == null) {
            throw new IllegalArgumentException("lower and upper Bounds may not be null with this constructor");
        }
        this.value = new Double(value);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.precision = precision;
    }

    public StatisticalNumber(Double nullAllowedValue) {
        this.value = nullAllowedValue;
        this.isNull = this.value == null;
    }

    public StatisticalNumber(Integer nullAllowedValue) {
        if (nullAllowedValue == null) {
            this.value = null;
            this.isNull = true;
        } else {
            this.value = new Double(nullAllowedValue.intValue());
        }
    }

    @Override
    public int compareTo(StatisticalNumber o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return -1;
        }
        return (int)(this.doubleValue() - o.doubleValue());
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    public Double getError() {
        return this.error;
    }

    public Double getLowerBound() {
        if (this.lowerBound == null) {
            return this.error == null ? null : Double.valueOf(this.value - this.error);
        }
        return this.lowerBound;
    }

    public byte getPrecision() {
        return this.precision;
    }

    public Double getUpperBound() {
        if (this.upperBound == null) {
            return this.error == null ? null : Double.valueOf(this.value + this.error);
        }
        return this.upperBound;
    }

    public Double getValue() {
        return this.value;
    }

    public boolean hasEnoughData() {
        return !this.isNull() && this.getValue() != null && this.getValue() != 0.0;
    }

    public boolean hasErrorBar() {
        return this.getLowerBound() != null;
    }

    public boolean hasSymmetricalErrorBar() {
        if (this.hasErrorBar()) {
            return this.getError() != null;
        }
        return false;
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    public boolean isNull() {
        return this.isNull;
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    public boolean isPvalue() {
        return this.pvalue;
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    public void setPrecision(byte precision) {
        this.precision = precision;
    }
}

