/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.settings;

import nl.strohalm.cyclos.utils.DataObject;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.WhitelistValidator;

public class AccessSettings
extends DataObject {
    private static final long serialVersionUID = 5443049128576812703L;
    private boolean virtualKeyboard = false;
    private boolean virtualKeyboardTransactionPassword = false;
    private boolean numericPassword = false;
    private boolean allowOperatorLogin = false;
    private boolean allowMultipleLogins = true;
    private TimePeriod adminTimeout = new TimePeriod(15, TimePeriod.Field.MINUTES);
    private String administrationWhitelist = "#Any host";
    private UsernameGeneration usernameGeneration = UsernameGeneration.NONE;
    private RangeConstraint usernameLength = new RangeConstraint(4, 12);
    private int generatedUsernameLength = 5;
    private TimePeriod memberTimeout = new TimePeriod(10, TimePeriod.Field.MINUTES);
    private String transactionPasswordChars = "ABCDEFGHIJ";
    private TimePeriod poswebTimeout = new TimePeriod(1, TimePeriod.Field.DAYS);
    private String usernameRegex = "^[\\w\\.]*$";
    private transient WhitelistValidator administrationWhitelistValidator;

    public String getAdministrationWhitelist() {
        return this.administrationWhitelist;
    }

    public WhitelistValidator getAdministrationWhitelistValidator() {
        if (this.administrationWhitelistValidator == null) {
            this.administrationWhitelistValidator = new WhitelistValidator(this.administrationWhitelist);
        }
        return this.administrationWhitelistValidator;
    }

    public TimePeriod getAdminTimeout() {
        return this.adminTimeout;
    }

    public int getGeneratedUsernameLength() {
        return this.generatedUsernameLength;
    }

    public TimePeriod getMemberTimeout() {
        return this.memberTimeout;
    }

    public TimePeriod getPoswebTimeout() {
        return this.poswebTimeout;
    }

    public String getTransactionPasswordChars() {
        return this.transactionPasswordChars;
    }

    public UsernameGeneration getUsernameGeneration() {
        return this.usernameGeneration;
    }

    public RangeConstraint getUsernameLength() {
        return this.usernameLength;
    }

    public String getUsernameRegex() {
        return this.usernameRegex;
    }

    public boolean isAllowMultipleLogins() {
        return this.allowMultipleLogins;
    }

    public boolean isAllowOperatorLogin() {
        return this.allowOperatorLogin;
    }

    public boolean isNumericPassword() {
        return this.numericPassword;
    }

    public boolean isUsernameGenerated() {
        return this.usernameGeneration != UsernameGeneration.NONE;
    }

    public boolean isVirtualKeyboard() {
        return this.virtualKeyboard;
    }

    public boolean isVirtualKeyboardTransactionPassword() {
        return this.virtualKeyboardTransactionPassword;
    }

    public void setAdministrationWhitelist(String administrationWhitelist) {
        this.administrationWhitelist = administrationWhitelist;
        this.administrationWhitelistValidator = null;
    }

    public void setAdminTimeout(TimePeriod adminTimeout) {
        this.adminTimeout = adminTimeout;
    }

    public void setAllowMultipleLogins(boolean allowMultipleLogins) {
        this.allowMultipleLogins = allowMultipleLogins;
    }

    public void setAllowOperatorLogin(boolean allowOperatorLogin) {
        this.allowOperatorLogin = allowOperatorLogin;
    }

    public void setGeneratedUsernameLength(int generatedUsernameLength) {
        this.generatedUsernameLength = generatedUsernameLength;
    }

    public void setMemberTimeout(TimePeriod memberTimeout) {
        this.memberTimeout = memberTimeout;
    }

    public void setNumericPassword(boolean numericPassword) {
        this.numericPassword = numericPassword;
    }

    public void setPoswebTimeout(TimePeriod poswebTimeout) {
        this.poswebTimeout = poswebTimeout;
    }

    public void setTransactionPasswordChars(String transactionPasswordChars) {
        this.transactionPasswordChars = transactionPasswordChars;
    }

    public void setUsernameGeneration(UsernameGeneration usernameGeneration) {
        this.usernameGeneration = usernameGeneration;
    }

    public void setUsernameLength(RangeConstraint usernameLength) {
        this.usernameLength = usernameLength;
    }

    public void setUsernameRegex(String usernameRegex) {
        this.usernameRegex = usernameRegex;
    }

    public void setVirtualKeyboard(boolean appletLogin) {
        this.virtualKeyboard = appletLogin;
    }

    public void setVirtualKeyboardTransactionPassword(boolean virtualKeyboardTransactionPassword) {
        this.virtualKeyboardTransactionPassword = virtualKeyboardTransactionPassword;
    }

    public static enum UsernameGeneration {
        NONE,
        RANDOM;

    }
}

