/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.settings;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.utils.DataObject;
import nl.strohalm.cyclos.utils.Dimensions;
import nl.strohalm.cyclos.utils.FileUnits;
import nl.strohalm.cyclos.utils.IntValuedEnum;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import nl.strohalm.cyclos.utils.TextFormat;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.conversion.AmountConverter;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.NumberConverter;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import nl.strohalm.cyclos.utils.lucene.LuceneUtils;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LocalSettings
extends DataObject {
    public static final int MAX_PRECISION = 10;
    public static final int BIG_DECIMAL_DIVISION_PRECISION = 6;
    private static final long serialVersionUID = -2880060408820762157L;
    private String applicationName = "Cyclos";
    private String cyclosId = null;
    private String applicationUsername = "The Administration";
    private Language language = Language.ENGLISH;
    private String rootUrl = "http://localhost:8080/cyclos";
    private String charset = "UTF-8";
    private NumberLocale numberLocale = NumberLocale.COMMA_AS_DECIMAL;
    private Precision precision = Precision.TWO;
    private Precision highPrecision = Precision.FOUR;
    private DecimalInputMethod decimalInputMethod = DecimalInputMethod.RTL;
    private DatePattern datePattern = DatePattern.DD_MM_YYYY_SLASH;
    private TimePattern timePattern = TimePattern.HH24_MM_SS;
    private TimeZone timeZone;
    private String containerUrl;
    private int maxIteratorResults = 1000;
    private int maxPageResults = 15;
    private int maxAjaxResults = 8;
    private int maxUploadSize = 5;
    private FileUnits maxUploadUnits = FileUnits.MEGA_BYTES;
    private int maxImageWidth = 800;
    private int maxImageHeight = 600;
    private int maxThumbnailWidth = 100;
    private int maxThumbnailHeight = 100;
    private int schedulingHour = 0;
    private int schedulingMinute = 0;
    private String transferListenerClass;
    private boolean csvUseHeader = true;
    private CsvRecordSeparator csvRecordSeparator = CsvRecordSeparator.LF;
    private CsvValueSeparator csvValueSeparator = CsvValueSeparator.COMMA;
    private CsvStringQuote csvStringQuote = CsvStringQuote.DOUBLE_QUOTE;
    private TransactionNumber transactionNumber = null;
    private String sendSmsWebServiceUrl = null;
    private String smsChannelName = null;
    private Long smsCustomFieldId = null;
    private boolean smsEnabled = false;
    private boolean emailRequired = true;
    private boolean emailUnique = true;
    private int referenceLevels = 5;
    private TimePeriod brokeringExpirationPeriod = new TimePeriod(0, TimePeriod.Field.YEARS);
    private TimePeriod deleteMessagesOnTrashAfter = new TimePeriod(30, TimePeriod.Field.DAYS);
    private TimePeriod deletePendingRegistrationsAfter = new TimePeriod(7, TimePeriod.Field.DAYS);
    private SortOrder memberSortOrder = SortOrder.CHRONOLOGICAL;
    private MemberResultDisplay memberResultDisplay = MemberResultDisplay.USERNAME;
    private TextFormat adDescriptionFormat = TextFormat.RICH;
    private TextFormat messageFormat = TextFormat.RICH;
    private TimePeriod maxChargebackTime = new TimePeriod(1, TimePeriod.Field.MONTHS);
    private String chargebackDescription = "Chargeback for payment at #date#\n#description#";
    private boolean showCountersInAdCategories = true;
    private transient Locale locale;
    private transient DecimalFormat decimalFormat;
    private transient NumberConverter<Long> longConverter;
    private transient DecimalFormat highPrecisionDecimalFormat;
    private transient DecimalFormatSymbols decimalSymbols;
    private transient NumberConverter<BigDecimal> numberConverter;
    private transient NumberConverter<BigDecimal> highPrecisionConverter;
    private final transient NumberConverter<BigDecimal>[] specificPrecisionConverters = new NumberConverter[11];
    private transient AmountConverter amountConverter;
    private transient CalendarConverter rawDateConverter;
    private transient CalendarConverter dateConverter;
    private transient CalendarConverter dateConverterForGraphs;
    private transient CalendarConverter dateTimeConverter;
    private transient CalendarConverter timeConverter;
    private transient Integer maxUploadBytes;
    private transient MathContext mathContext;
    private transient Comparator<Element> memberComparator;
    private transient Dimensions maxImageDimensions;
    private transient Dimensions maxThumbnailDimensions;
    private transient List<Reference.Level> referenceLevelList;

    public TextFormat getAdDescriptionFormat() {
        return this.adDescriptionFormat;
    }

    public AmountConverter getAmountConverter() {
        if (this.amountConverter == null) {
            this.amountConverter = new AmountConverter(this.getDecimalFormat());
        }
        return this.amountConverter;
    }

    public AmountConverter getAmountConverter(String unitsPattern) {
        return new AmountConverter(this.getDecimalFormat(), unitsPattern);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationUsername() {
        return this.applicationUsername;
    }

    public TimePeriod getBrokeringExpirationPeriod() {
        return this.brokeringExpirationPeriod;
    }

    public String getChargebackDescription() {
        return this.chargebackDescription;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getContainerUrl() {
        return this.containerUrl;
    }

    public CsvRecordSeparator getCsvRecordSeparator() {
        return this.csvRecordSeparator;
    }

    public CsvStringQuote getCsvStringQuote() {
        return this.csvStringQuote;
    }

    public CsvValueSeparator getCsvValueSeparator() {
        return this.csvValueSeparator;
    }

    public String getCyclosId() {
        return this.cyclosId;
    }

    public CalendarConverter getDateConverter() {
        if (this.dateConverter == null) {
            this.dateConverter = new CalendarConverter(this.datePattern.value, this.timeZone);
        }
        return this.dateConverter;
    }

    public CalendarConverter getDateConverterForGraphs() {
        if (this.dateConverterForGraphs == null) {
            String[] formatParts = this.datePattern.order.getFormatParts();
            ArrayList<String> formatPartsForGraph = new ArrayList<String>(formatParts.length - 1);
            for (String formatPart : formatParts) {
                if (formatPart.toLowerCase().indexOf(121) != -1) continue;
                formatPartsForGraph.add(formatPart);
            }
            Object[] formatPartsForGraphArray = new String[formatPartsForGraph.size()];
            formatPartsForGraphArray = formatPartsForGraph.toArray(formatPartsForGraphArray);
            String patternValue = StringUtils.join((Object[])formatPartsForGraphArray, (char)this.datePattern.separator);
            this.dateConverterForGraphs = new CalendarConverter(patternValue, this.timeZone);
        }
        return this.dateConverterForGraphs;
    }

    public DatePattern getDatePattern() {
        return this.datePattern;
    }

    public CalendarConverter getDateTimeConverter() {
        if (this.dateTimeConverter == null) {
            this.dateTimeConverter = new CalendarConverter(this.datePattern.value + " " + this.timePattern.value, this.timeZone);
        }
        return this.dateTimeConverter;
    }

    public DecimalInputMethod getDecimalInputMethod() {
        return this.decimalInputMethod;
    }

    public DecimalFormatSymbols getDecimalSymbols() {
        if (this.decimalSymbols == null) {
            this.decimalSymbols = new DecimalFormatSymbols(this.numberLocale.getLocale());
        }
        return this.decimalSymbols;
    }

    public TimePeriod getDeleteMessagesOnTrashAfter() {
        return this.deleteMessagesOnTrashAfter;
    }

    public TimePeriod getDeletePendingRegistrationsAfter() {
        return this.deletePendingRegistrationsAfter;
    }

    public Precision getHighPrecision() {
        return this.highPrecision;
    }

    public NumberConverter<BigDecimal> getHighPrecisionConverter() {
        if (this.highPrecisionConverter == null) {
            this.highPrecisionConverter = new NumberConverter<BigDecimal>(BigDecimal.class, this.getHighPrecisionDecimalFormat());
        }
        return this.highPrecisionConverter;
    }

    public DecimalFormat getHighPrecisionDecimalFormat() {
        if (this.highPrecisionDecimalFormat == null) {
            this.highPrecisionDecimalFormat = this.getDecimalFormat(this.highPrecision.value);
        }
        return this.highPrecisionDecimalFormat;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.language.getLocale();
        }
        return this.locale;
    }

    public NumberConverter<Long> getLongConverter() {
        if (this.longConverter == null) {
            this.longConverter = new NumberConverter<Long>(Long.class, this.getDecimalFormat(0));
        }
        return this.longConverter;
    }

    public MathContext getMathContext() {
        if (this.mathContext == null) {
            this.mathContext = new MathContext(6);
        }
        return this.mathContext;
    }

    public int getMaxAjaxResults() {
        return this.maxAjaxResults;
    }

    public TimePeriod getMaxChargebackTime() {
        return this.maxChargebackTime;
    }

    public Dimensions getMaxImageDimensions() {
        if (this.maxImageDimensions == null) {
            this.maxImageDimensions = new Dimensions(this.maxImageWidth, this.maxImageHeight);
        }
        return this.maxImageDimensions;
    }

    public int getMaxImageHeight() {
        return this.maxImageHeight;
    }

    public int getMaxImageWidth() {
        return this.maxImageWidth;
    }

    public int getMaxIteratorResults() {
        return this.maxIteratorResults;
    }

    public int getMaxPageResults() {
        return this.maxPageResults;
    }

    public Dimensions getMaxThumbnailDimensions() {
        if (this.maxThumbnailDimensions == null) {
            this.maxThumbnailDimensions = new Dimensions(this.maxThumbnailWidth, this.maxThumbnailHeight);
        }
        return this.maxThumbnailDimensions;
    }

    public int getMaxThumbnailHeight() {
        return this.maxThumbnailHeight;
    }

    public int getMaxThumbnailWidth() {
        return this.maxThumbnailWidth;
    }

    public int getMaxUploadBytes() {
        if (this.maxUploadBytes == null) {
            this.maxUploadBytes = this.maxUploadUnits.calculate(this.maxUploadSize);
        }
        return this.maxUploadBytes;
    }

    public int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public FileUnits getMaxUploadUnits() {
        return this.maxUploadUnits;
    }

    public Comparator<Element> getMemberComparator() {
        if (this.memberComparator == null) {
            this.memberComparator = new BeanComparator(this.memberResultDisplay.getProperty());
        }
        return this.memberComparator;
    }

    public MemberResultDisplay getMemberResultDisplay() {
        return this.memberResultDisplay;
    }

    public SortOrder getMemberSortOrder() {
        return this.memberSortOrder;
    }

    public TextFormat getMessageFormat() {
        return this.messageFormat;
    }

    public NumberConverter<BigDecimal> getNumberConverter() {
        if (this.numberConverter == null) {
            this.numberConverter = new NumberConverter<BigDecimal>(BigDecimal.class, this.getDecimalFormat());
        }
        return this.numberConverter;
    }

    public NumberConverter<BigDecimal> getNumberConverterForPrecision(int precision) {
        if (this.specificPrecisionConverters[precision = Math.max(0, Math.min(precision, 10))] == null) {
            this.specificPrecisionConverters[precision] = new NumberConverter<BigDecimal>(BigDecimal.class, this.getDecimalFormat(precision));
        }
        return this.specificPrecisionConverters[precision];
    }

    public NumberLocale getNumberLocale() {
        return this.numberLocale;
    }

    public Precision getPrecision() {
        return this.precision;
    }

    public CalendarConverter getRawDateConverter() {
        if (this.rawDateConverter == null) {
            this.rawDateConverter = new CalendarConverter(this.datePattern.value);
        }
        return this.rawDateConverter;
    }

    public List<Reference.Level> getReferenceLevelList() {
        if (this.referenceLevelList == null) {
            Reference.Level[] levels = this.referenceLevels == 3 ? new Reference.Level[]{Reference.Level.GOOD, Reference.Level.NEUTRAL, Reference.Level.BAD} : Reference.Level.values();
            this.referenceLevelList = Collections.unmodifiableList(Arrays.asList(levels));
        }
        return this.referenceLevelList;
    }

    public int getReferenceLevels() {
        return this.referenceLevels;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public int getSchedulingHour() {
        return this.schedulingHour;
    }

    public int getSchedulingMinute() {
        return this.schedulingMinute;
    }

    public String getSendSmsWebServiceUrl() {
        return this.sendSmsWebServiceUrl;
    }

    public String getSmsChannelName() {
        return this.smsChannelName;
    }

    public Long getSmsCustomFieldId() {
        return this.smsCustomFieldId;
    }

    public CalendarConverter getTimeConverter() {
        if (this.timeConverter == null) {
            this.timeConverter = new CalendarConverter(this.timePattern.value, this.timeZone);
        }
        return this.timeConverter;
    }

    public TimePattern getTimePattern() {
        return this.timePattern;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public TransactionNumber getTransactionNumber() {
        return this.transactionNumber;
    }

    public String getTransferListenerClass() {
        return this.transferListenerClass;
    }

    public UnitsConverter getUnitsConverter(String pattern) {
        return new UnitsConverter(pattern, this.getNumberConverter().getNumberFormat());
    }

    public boolean isCsvUseHeader() {
        return this.csvUseHeader;
    }

    public boolean isEmailRequired() {
        return this.emailRequired;
    }

    public boolean isEmailUnique() {
        return this.emailUnique;
    }

    public boolean isShowCountersInAdCategories() {
        return this.showCountersInAdCategories;
    }

    public boolean isSmsCommandEnabled() {
        return StringUtils.isNotEmpty((String)this.smsChannelName);
    }

    public boolean isSmsEnabled() {
        return this.smsEnabled;
    }

    public BigDecimal round(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return number.setScale(this.getPrecision().getValue(), RoundingMode.HALF_UP);
    }

    public BigDecimal roundHighPrecision(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return number.setScale(this.getHighPrecision().getValue(), RoundingMode.HALF_UP);
    }

    public void setAdDescriptionFormat(TextFormat adDescriptionFormat) {
        this.adDescriptionFormat = adDescriptionFormat;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setApplicationUsername(String applicationUsername) {
        this.applicationUsername = applicationUsername;
    }

    public void setBrokeringExpirationPeriod(TimePeriod brokeringExpirationPeriod) {
        this.brokeringExpirationPeriod = brokeringExpirationPeriod;
    }

    public void setChargebackDescription(String chargebackDescription) {
        this.chargebackDescription = chargebackDescription;
    }

    public void setContainerUrl(String containerUrl) {
        this.containerUrl = containerUrl;
    }

    public void setCsvRecordSeparator(CsvRecordSeparator csvRecordSeparator) {
        this.csvRecordSeparator = csvRecordSeparator;
    }

    public void setCsvStringQuote(CsvStringQuote csvStringQuote) {
        this.csvStringQuote = csvStringQuote;
    }

    public void setCsvUseHeader(boolean csvUseHeader) {
        this.csvUseHeader = csvUseHeader;
    }

    public void setCsvValueSeparator(CsvValueSeparator csvValueSeparator) {
        this.csvValueSeparator = csvValueSeparator;
    }

    public void setCyclosId(String cyclosId) {
        this.cyclosId = cyclosId;
    }

    public void setDatePattern(DatePattern datePattern) {
        this.datePattern = datePattern;
        this.invalidateDateParams();
    }

    public void setDecimalInputMethod(DecimalInputMethod decimalInputMethod) {
        this.decimalInputMethod = decimalInputMethod;
    }

    public void setDeleteMessagesOnTrashAfter(TimePeriod deleteMessagesOnTrashAfter) {
        this.deleteMessagesOnTrashAfter = deleteMessagesOnTrashAfter;
    }

    public void setDeletePendingRegistrationsAfter(TimePeriod deletePendingRegistrationsAfter) {
        this.deletePendingRegistrationsAfter = deletePendingRegistrationsAfter;
    }

    public void setEmailRequired(boolean mailRequired) {
        this.emailRequired = mailRequired;
    }

    public void setEmailUnique(boolean emailUnique) {
        this.emailUnique = emailUnique;
    }

    public void setHighPrecision(Precision highPrecision) {
        this.highPrecision = highPrecision;
    }

    public void setLanguage(Language language) {
        this.language = language == null ? Language.ENGLISH : language;
        this.invalidateLanguageParams();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMaxAjaxResults(int maxAjaxResults) {
        this.maxAjaxResults = maxAjaxResults;
    }

    public void setMaxChargebackTime(TimePeriod maxChargebackTime) {
        this.maxChargebackTime = maxChargebackTime;
    }

    public void setMaxImageHeight(int maxImageHeight) {
        this.maxImageHeight = maxImageHeight;
    }

    public void setMaxImageWidth(int maxImageWidth) {
        this.maxImageWidth = maxImageWidth;
    }

    public void setMaxIteratorResults(int maxIteratorPageResults) {
        this.maxIteratorResults = maxIteratorPageResults;
    }

    public void setMaxPageResults(int pageSize) {
        this.maxPageResults = pageSize;
    }

    public void setMaxThumbnailHeight(int maxThumbnailHeight) {
        this.maxThumbnailHeight = maxThumbnailHeight;
    }

    public void setMaxThumbnailWidth(int maxThumbnailWidth) {
        this.maxThumbnailWidth = maxThumbnailWidth;
    }

    public void setMaxUploadSize(int maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
        this.maxUploadBytes = null;
    }

    public void setMaxUploadUnits(FileUnits maxUploadUnits) {
        this.maxUploadUnits = maxUploadUnits;
        this.maxUploadBytes = null;
    }

    public void setMemberResultDisplay(MemberResultDisplay adResultDisplay) {
        this.memberResultDisplay = adResultDisplay;
        this.memberComparator = null;
    }

    public void setMemberSortOrder(SortOrder memberSortOrder) {
        this.memberSortOrder = memberSortOrder;
    }

    public void setMessageFormat(TextFormat messageFormat) {
        this.messageFormat = messageFormat;
    }

    public void setNumberLocale(NumberLocale numberLocale) {
        this.numberLocale = numberLocale;
        this.invalidateNumberParams();
    }

    public void setPrecision(Precision precision) {
        this.precision = precision;
        this.invalidateNumberParams();
    }

    public void setReferenceLevels(int referenceLevels) {
        this.referenceLevels = referenceLevels;
        this.referenceLevelList = null;
    }

    public void setRootUrl(String rootUrl) {
        this.rootUrl = rootUrl;
    }

    public void setSchedulingHour(int schedulingHour) {
        this.schedulingHour = schedulingHour;
    }

    public void setSchedulingMinute(int schedulingMinute) {
        this.schedulingMinute = schedulingMinute;
    }

    public void setSendSmsWebServiceUrl(String sendSmsWebServiceUrl) {
        this.sendSmsWebServiceUrl = sendSmsWebServiceUrl;
    }

    public void setShowCountersInAdCategories(boolean showCountersInAdCategories) {
        this.showCountersInAdCategories = showCountersInAdCategories;
    }

    public void setSmsChannelName(String smsChannelName) {
        this.smsChannelName = smsChannelName;
    }

    public void setSmsCustomFieldId(Long smsCustomFieldId) {
        this.smsCustomFieldId = smsCustomFieldId;
    }

    public void setSmsEnabled(boolean smsEnabled) {
        this.smsEnabled = smsEnabled;
    }

    public void setTimePattern(TimePattern timePattern) {
        this.timePattern = timePattern;
        this.invalidateDateParams();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.invalidateDateParams();
    }

    public void setTransactionNumber(TransactionNumber transactionNumber) {
        this.transactionNumber = transactionNumber;
    }

    public void setTransferListenerClass(String transferListenerClass) {
        this.transferListenerClass = transferListenerClass;
    }

    public BigDecimal truncate(BigDecimal number) {
        if (number == null) {
            return null;
        }
        return number.setScale(this.getPrecision().getValue(), RoundingMode.FLOOR);
    }

    private DecimalFormat getDecimalFormat() {
        if (this.decimalFormat == null) {
            this.decimalFormat = this.getDecimalFormat(this.precision.value);
        }
        return this.decimalFormat;
    }

    private DecimalFormat getDecimalFormat(int precision) {
        String pattern = "#,##0";
        if (precision > 0) {
            pattern = pattern + "." + StringUtils.repeat((String)"0", (int)precision);
        }
        return new DecimalFormat(pattern, this.getDecimalSymbols());
    }

    private void invalidateDateParams() {
        this.rawDateConverter = null;
        this.dateConverter = null;
        this.dateTimeConverter = null;
        this.dateConverterForGraphs = null;
        this.timeConverter = null;
    }

    private void invalidateLanguageParams() {
        this.locale = null;
    }

    private void invalidateNumberParams() {
        this.longConverter = null;
        this.decimalFormat = null;
        this.amountConverter = null;
        this.highPrecisionConverter = null;
        this.numberConverter = null;
        this.decimalSymbols = null;
        this.mathContext = null;
        for (int i = 0; i < this.specificPrecisionConverters.length; ++i) {
            this.specificPrecisionConverters[i] = null;
        }
    }

    public static class TransactionNumber
    implements Serializable {
        private static final long serialVersionUID = 7841112633641561669L;
        private String prefix;
        private int padLength;
        private String suffix;
        private boolean enabled;

        public TransactionNumber() {
        }

        public TransactionNumber(String prefix, int padLength, String suffix) {
            this.prefix = prefix;
            this.padLength = padLength;
            this.suffix = suffix;
        }

        public String generate(Long id, Calendar date) {
            if (this.padLength <= 0) {
                throw new IllegalStateException("Cannot generate a transaction number with padLength " + this.padLength);
            }
            if (id == null || id <= 0L) {
                throw new IllegalArgumentException("Invalid id: " + id);
            }
            return MessageProcessingHelper.processDate(this.prefix, date) + StringUtils.leftPad((String)String.valueOf(id), (int)this.padLength, (char)'0') + MessageProcessingHelper.processDate(this.suffix, date);
        }

        public int getPadLength() {
            return this.padLength;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isValid() {
            return this.padLength > 0;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setPadLength(int padLength) {
            this.padLength = padLength;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }
    }

    public static enum TimePattern implements StringValuedEnum
    {
        HH24_MM_SS("HH:mm:ss", "HH(24):MM:SS", "%H:%M:%S"),
        HH24_MM("HH:mm", "HH(24):MM", "%H:%M"),
        HH12_MM_SS("hh:mm:ss a", "HH(12):MM:SS AM/PM", "%I:%M:%S %p"),
        HH12_MM("hh:mm a", "HH(12):MM AM/PM", "%I:%M %p");

        private final String value;
        private final String description;
        private final String calendarFormat;

        private TimePattern(String value, String description, String calendarFormat) {
            this.value = value;
            this.description = description;
            this.calendarFormat = calendarFormat;
        }

        public String getCalendarFormat() {
            return this.calendarFormat;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum SortOrder {
        CHRONOLOGICAL,
        ALPHABETICAL;

    }

    public static enum Precision implements IntValuedEnum
    {
        ZERO(0),
        ONE(1),
        TWO(2),
        THREE(3),
        FOUR(4),
        FIVE(5),
        SIX(6);

        private final int value;

        private Precision(int value) {
            this.value = value;
        }

        public MathContext getMathContext() {
            return new MathContext(this.value, RoundingMode.HALF_UP);
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    public static enum NumberLocale {
        PERIOD_AS_DECIMAL(Locale.US),
        COMMA_AS_DECIMAL(Locale.GERMANY);

        private final Locale locale;

        private NumberLocale(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }

    public static enum MemberResultDisplay {
        USERNAME,
        NAME;


        public String getProperty() {
            return this.name().toLowerCase();
        }
    }

    public static enum Language implements StringValuedEnum
    {
        ENGLISH("en_US", "en"),
        SPANISH("es_ES", "es"),
        CZECH("cs_CZ", "cs"),
        GERMAN("de_DE", "de", (Analyzer)new GermanAnalyzer(LuceneUtils.LUCENE_VERSION)),
        GREEK("el_GR", "el", (Analyzer)new GreekAnalyzer(LuceneUtils.LUCENE_VERSION)),
        DUTCH("nl_NL", "nl"),
        PORTUGUESE_BRAZIL("pt_BR", "pt-br", (Analyzer)new BrazilianAnalyzer(LuceneUtils.LUCENE_VERSION)),
        CHINESE_SIMPLIFIED("zh_CN", "zh-cn"),
        FRENCH("fr_FR", "fr", (Analyzer)new FrenchAnalyzer(LuceneUtils.LUCENE_VERSION)),
        JAPANESE("ja_JP", "jp"),
        ITALIAN("it_IT", "it"),
        RUSSIAN("ru_RU", "ru");

        private final Locale locale;
        private final String value;
        private final String alternate;
        private final Analyzer analyzer;

        private Language(String value, String alternate) {
            this(value, alternate, (Analyzer)new StandardAnalyzer(LuceneUtils.LUCENE_VERSION));
        }

        private Language(String value, String alternate, Analyzer analyzer) {
            this.value = value;
            this.locale = CoercionHelper.coerce(Locale.class, value);
            this.alternate = alternate;
            this.analyzer = analyzer;
        }

        public String getAlternate() {
            return this.alternate;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public Locale getLocale() {
            return this.locale;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum DecimalInputMethod {
        RTL,
        LTR;

    }

    public static enum DatePatternOrder {
        YMD,
        MDY,
        DMY;


        public String[] getCalendarParts() {
            switch (this) {
                case DMY: {
                    return new String[]{"%d", "%m", "%Y"};
                }
                case MDY: {
                    return new String[]{"%m", "%d", "%Y"};
                }
                case YMD: {
                    return new String[]{"%Y", "%m", "%d"};
                }
            }
            return null;
        }

        public String[] getFormatParts() {
            switch (this) {
                case DMY: {
                    return new String[]{"dd", "MM", "yyyy"};
                }
                case MDY: {
                    return new String[]{"MM", "dd", "yyyy"};
                }
                case YMD: {
                    return new String[]{"yyyy", "MM", "dd"};
                }
            }
            return null;
        }
    }

    public static enum DatePattern implements StringValuedEnum
    {
        YYYY_MM_DD_SLASH(DatePatternOrder.YMD, '/'),
        YYYY_MM_DD_PERIOD(DatePatternOrder.YMD, '.'),
        YYYY_MM_DD_DASH(DatePatternOrder.YMD, '-'),
        MM_DD_YYYY_SLASH(DatePatternOrder.MDY, '/'),
        MM_DD_YYYY_PERIOD(DatePatternOrder.MDY, '.'),
        MM_DD_YYYY_DASH(DatePatternOrder.MDY, '-'),
        DD_MM_YYYY_SLASH(DatePatternOrder.DMY, '/'),
        DD_MM_YYYY_PERIOD(DatePatternOrder.DMY, '.'),
        DD_MM_YYYY_DASH(DatePatternOrder.DMY, '-');

        private final DatePatternOrder order;
        private final String value;
        private final char separator;
        private final String calendarFormat;
        private final String pattern;

        private DatePattern(DatePatternOrder order, char separator) {
            this.order = order;
            this.separator = separator;
            this.value = StringUtils.join((Object[])order.getFormatParts(), (char)separator);
            this.calendarFormat = StringUtils.join((Object[])order.getCalendarParts(), (char)separator);
            StringBuilder sb = new StringBuilder();
            for (String part : order.getCalendarParts()) {
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.append(StringUtils.repeat((String)"#", (int)part.length()));
            }
            this.pattern = sb.toString();
        }

        public String getCalendarFormat() {
            return this.calendarFormat;
        }

        public DatePatternOrder getOrder() {
            return this.order;
        }

        public String getPattern() {
            return this.pattern;
        }

        public char getSeparator() {
            return this.separator;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum CsvValueSeparator implements StringValuedEnum
    {
        COMMA(","),
        SEMICOLON(";"),
        TAB("\t");

        private final String value;

        private CsvValueSeparator(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum CsvStringQuote implements StringValuedEnum
    {
        DOUBLE_QUOTE("\""),
        SINGLE_QUOTE("'"),
        NONE("");

        private final String value;

        private CsvStringQuote(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum CsvRecordSeparator implements StringValuedEnum
    {
        LF("\n"),
        CR_LF("\r\n"),
        CR("\r");

        private final String value;

        private CsvRecordSeparator(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

