/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.settings;

import java.util.Properties;
import nl.strohalm.cyclos.utils.DataObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class MailSettings
extends DataObject {
    private static final long serialVersionUID = 5208856489563893834L;
    private String fromMail = "noreply@cyclos.org";
    private String smtpServer = "localhost";
    private int smtpPort = 25;
    private String smtpUsername;
    private String smtpPassword;
    private boolean smtpUseTLS = false;
    private transient JavaMailSender mailSender;

    public String getFromMail() {
        return this.fromMail;
    }

    public JavaMailSender getMailSender() {
        if (this.mailSender == null) {
            JavaMailSenderImpl impl = new JavaMailSenderImpl();
            impl.setHost(this.smtpServer);
            impl.setPort(this.smtpPort);
            Properties properties = new Properties();
            if (StringUtils.isNotEmpty((String)this.smtpUsername)) {
                properties.setProperty("mail.smtp.auth", "true");
                impl.setUsername(this.smtpUsername);
                impl.setPassword(this.smtpPassword);
            }
            if (this.smtpUseTLS) {
                properties.setProperty("mail.smtp.starttls.enable", "true");
            }
            impl.setJavaMailProperties(properties);
            this.mailSender = impl;
        }
        return this.mailSender;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    public boolean isSmtpAuthenticate() {
        return StringUtils.isNotEmpty((String)this.smtpUsername);
    }

    public boolean isSmtpUseTLS() {
        return this.smtpUseTLS;
    }

    public void setFromMail(String fromMail) {
        this.fromMail = fromMail;
        this.mailSender = null;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
        this.mailSender = null;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
        this.mailSender = null;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
        this.mailSender = null;
    }

    public void setSmtpUsername(String smtpUsername) {
        this.smtpUsername = smtpUsername;
        this.mailSender = null;
    }

    public void setSmtpUseTLS(boolean smtpUseTLS) {
        this.smtpUseTLS = smtpUseTLS;
        this.mailSender = null;
    }
}

