/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.sms;

import java.util.Calendar;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.sms.SmsLogStatus;
import nl.strohalm.cyclos.entities.sms.SmsLogType;
import nl.strohalm.cyclos.entities.sms.SmsMailing;
import nl.strohalm.cyclos.entities.sms.SmsType;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.StringValuedEnum;
import org.apache.commons.lang.StringUtils;

public class SmsLog
extends Entity {
    private static final short MAX_ARG_LEN = 150;
    private static final long serialVersionUID = -4331781757069220677L;
    private Member targetMember;
    private Member chargedMember;
    private Calendar date;
    private Message.Type messageType;
    private SmsMailing smsMailing;
    private boolean freeBaseUsed;
    private SmsType smsType;
    private ErrorType errorType;
    protected String arg0;
    protected String arg1;
    protected String arg2;
    protected String arg3;
    protected String arg4;

    private static String ensureArgLength(String arg) {
        return StringUtils.substring((String)arg, (int)0, (int)150);
    }

    public String getArg0() {
        return this.arg0;
    }

    public String getArg1() {
        return this.arg1;
    }

    public String getArg2() {
        return this.arg2;
    }

    public String getArg3() {
        return this.arg3;
    }

    public String getArg4() {
        return this.arg4;
    }

    public Member getChargedMember() {
        return this.chargedMember;
    }

    public Calendar getDate() {
        return this.date;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public Message.Type getMessageType() {
        return this.messageType;
    }

    public SmsMailing getSmsMailing() {
        return this.smsMailing;
    }

    public SmsType getSmsType() {
        return this.smsType;
    }

    public SmsLogStatus getStatus() {
        if (this.errorType != null) {
            return SmsLogStatus.ERROR;
        }
        return SmsLogStatus.DELIVERED;
    }

    public Member getTargetMember() {
        return this.targetMember;
    }

    public SmsLogType getType() {
        if (this.smsMailing != null) {
            return SmsLogType.MAILING;
        }
        if (this.messageType != null) {
            return SmsLogType.NOTIFICATION;
        }
        if (this.smsType != null) {
            return SmsLogType.SMS_OPERATION;
        }
        return null;
    }

    public boolean isFree() {
        if (this.smsMailing != null && this.smsMailing.isFree()) {
            return true;
        }
        return this.freeBaseUsed;
    }

    public boolean isFreeBaseUsed() {
        return this.freeBaseUsed;
    }

    public boolean isSuccessful() {
        return this.errorType == null;
    }

    public void setArg0(String arg0) {
        this.arg0 = SmsLog.ensureArgLength(arg0);
    }

    public void setArg1(String arg1) {
        this.arg1 = SmsLog.ensureArgLength(arg1);
    }

    public void setArg2(String arg2) {
        this.arg2 = SmsLog.ensureArgLength(arg2);
    }

    public void setArg3(String arg3) {
        this.arg3 = SmsLog.ensureArgLength(arg3);
    }

    public void setArg4(String arg4) {
        this.arg4 = SmsLog.ensureArgLength(arg4);
    }

    public void setChargedMember(Member chargedMember) {
        this.chargedMember = chargedMember;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public void setFreeBaseUsed(boolean freeBaseUsed) {
        this.freeBaseUsed = freeBaseUsed;
    }

    public void setMessageType(Message.Type messageType) {
        this.messageType = messageType;
    }

    public void setSmsMailing(SmsMailing smsMailing) {
        this.smsMailing = smsMailing;
    }

    public void setSmsType(SmsType smsType) {
        this.smsType = smsType;
    }

    public void setSmsTypeArgs(String[] smsTypeArgs) {
        if (smsTypeArgs != null) {
            this.setArg0(smsTypeArgs.length > 0 ? smsTypeArgs[0] : null);
            this.setArg1(smsTypeArgs.length > 1 ? smsTypeArgs[1] : null);
            this.setArg2(smsTypeArgs.length > 2 ? smsTypeArgs[2] : null);
            this.setArg3(smsTypeArgs.length > 3 ? smsTypeArgs[3] : null);
            this.setArg4(smsTypeArgs.length > 4 ? smsTypeArgs[4] : null);
        }
    }

    public void setTargetMember(Member targetMember) {
        this.targetMember = targetMember;
    }

    @Override
    public String toString() {
        return "SmsLog [id=" + this.getId() + ", chargedMember=" + this.chargedMember + ", date=" + FormatObject.formatObject(this.date) + ", errorType=" + this.errorType + ", freeBaseUsed=" + this.freeBaseUsed + ", messageType=" + this.messageType + ", smsMailing=" + this.smsMailing + ", smsType=" + this.smsType + ", targetMember=" + this.targetMember + "]";
    }

    public static enum Relationships implements Relationship
    {
        TARGET_MEMBER("targetMember"),
        CHARGED_MEMBER("chargedMember"),
        SMS_MAILING("smsMailing"),
        SMS_TYPE("smsType");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static enum ErrorType implements StringValuedEnum
    {
        NOT_ENOUGH_FUNDS("NEF"),
        ALLOW_CHARGING_DISABLED("ACD"),
        NO_SMS_LEFT("NL"),
        NO_PHONE("NP"),
        SEND_ERROR("SE");

        private final String value;

        private ErrorType(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

