/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.sms;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.entities.sms.SmsLog;
import nl.strohalm.cyclos.entities.sms.SmsLogStatus;
import nl.strohalm.cyclos.entities.sms.SmsLogType;

public class SmsLogReportVO {
    private Map<SmsLogType, Map<SmsLogStatus, Integer>> totals;
    private List<SmsLog> logs;

    public List<SmsLog> getLogs() {
        return this.logs;
    }

    public int getTotal() {
        if (this.totals == null) {
            return 0;
        }
        int total = 0;
        for (Map<SmsLogStatus, Integer> map : this.totals.values()) {
            for (Integer value : map.values()) {
                total += value.intValue();
            }
        }
        return total;
    }

    public Map<SmsLogType, Map<SmsLogStatus, Integer>> getTotals() {
        return this.totals;
    }

    public Map<SmsLogStatus, Integer> getTotalsByStatus() {
        if (this.totals == null) {
            return null;
        }
        EnumMap<SmsLogStatus, Integer> result = new EnumMap<SmsLogStatus, Integer>(SmsLogStatus.class);
        for (Map.Entry<SmsLogType, Map<SmsLogStatus, Integer>> outerEntry : this.totals.entrySet()) {
            for (Map.Entry<SmsLogStatus, Integer> entry : outerEntry.getValue().entrySet()) {
                SmsLogStatus status = entry.getKey();
                Integer current = (Integer)result.get((Object)status);
                int value = current == null ? entry.getValue() : current + entry.getValue();
                result.put(status, value);
            }
        }
        return result;
    }

    public Map<SmsLogType, Integer> getTotalsByType() {
        if (this.totals == null) {
            return null;
        }
        EnumMap<SmsLogType, Integer> result = new EnumMap<SmsLogType, Integer>(SmsLogType.class);
        for (Map.Entry<SmsLogType, Map<SmsLogStatus, Integer>> entry : this.totals.entrySet()) {
            int total = 0;
            for (Integer value : entry.getValue().values()) {
                total += value.intValue();
            }
            result.put(entry.getKey(), total);
        }
        return result;
    }

    public void setLogs(List<SmsLog> logs) {
        this.logs = logs;
    }

    public void setTotals(SmsLogType type, SmsLogStatus status, int total) {
        if (this.totals == null) {
            this.initTotals();
        }
        this.totals.get((Object)type).put(status, total);
    }

    private void initTotals() {
        this.totals = new EnumMap<SmsLogType, Map<SmsLogStatus, Integer>>(SmsLogType.class);
        for (SmsLogType type : SmsLogType.values()) {
            EnumMap<SmsLogStatus, Integer> byStatus = new EnumMap<SmsLogStatus, Integer>(SmsLogStatus.class);
            this.totals.put(type, byStatus);
            for (SmsLogStatus status : SmsLogStatus.values()) {
                byStatus.put(status, 0);
            }
        }
    }
}

