/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.entities.sms;

import java.util.Calendar;
import java.util.Collection;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.sms.SmsMailingType;
import nl.strohalm.cyclos.utils.FormatObject;

public class SmsMailing
extends Entity {
    private static final long serialVersionUID = 2525066930563530937L;
    private Calendar date;
    private Element by;
    private String text;
    private int sentSms;
    private boolean free;
    private Collection<MemberGroup> groups;
    private Member member;
    private Collection<Member> pendingToSend;
    private transient boolean finished;

    public Element getBy() {
        return this.by;
    }

    public Calendar getDate() {
        return this.date;
    }

    public Collection<MemberGroup> getGroups() {
        return this.groups;
    }

    public Member getMember() {
        return this.member;
    }

    public Collection<Member> getPendingToSend() {
        return this.pendingToSend;
    }

    public int getSentSms() {
        return this.sentSms;
    }

    public String getText() {
        return this.text;
    }

    public SmsMailingType getType() {
        if (this.isSingleMember()) {
            return SmsMailingType.INDIVIDUAL;
        }
        if (this.by == null || this.by.getNature() == Element.Nature.ADMIN) {
            return this.free ? SmsMailingType.FREE_TO_GROUP : SmsMailingType.PAID_TO_GROUP;
        }
        return this.free ? SmsMailingType.FREE_FROM_BROKER : SmsMailingType.PAID_FROM_BROKER;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isFree() {
        return this.free;
    }

    public boolean isSingleMember() {
        return this.member != null;
    }

    public void setBy(Element by) {
        this.by = by;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public void setGroups(Collection<MemberGroup> groups) {
        this.groups = groups;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public void setPendingToSend(Collection<Member> pendingToSend) {
        this.pendingToSend = pendingToSend;
    }

    public void setSentSms(int sentSms) {
        this.sentSms = sentSms;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return this.getId() + " - " + FormatObject.formatObject(this.date);
    }

    public static enum Relationships implements Relationship
    {
        BY("by"),
        PENDING_TO_SEND("pendingToSend"),
        GROUPS("groups"),
        MEMBER("member");

        private final String name;

        private Relationships(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

