/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public interface AttributeHolder {
    public Object getAttribute(String var1);

    public Enumeration<String> getAttributeNames();

    public void removeAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public static class Factory {
        public static AttributeHolder context(final ServletContext servletContext) {
            return new AttributeHolder(){

                @Override
                public Object getAttribute(String name) {
                    return servletContext.getAttribute(name);
                }

                @Override
                public Enumeration<String> getAttributeNames() {
                    return servletContext.getAttributeNames();
                }

                @Override
                public void removeAttribute(String name) {
                    servletContext.removeAttribute(name);
                }

                @Override
                public void setAttribute(String name, Object value) {
                    servletContext.setAttribute(name, value);
                }
            };
        }

        public static AttributeHolder request(final HttpServletRequest request) {
            return new AttributeHolder(){

                @Override
                public Object getAttribute(String name) {
                    return request.getAttribute(name);
                }

                @Override
                public Enumeration<String> getAttributeNames() {
                    return request.getAttributeNames();
                }

                @Override
                public void removeAttribute(String name) {
                    request.removeAttribute(name);
                }

                @Override
                public void setAttribute(String name, Object value) {
                    request.setAttribute(name, value);
                }
            };
        }

        public static AttributeHolder session(final HttpSession session) {
            return new AttributeHolder(){

                @Override
                public Object getAttribute(String name) {
                    return session.getAttribute(name);
                }

                @Override
                public Enumeration<String> getAttributeNames() {
                    return session.getAttributeNames();
                }

                @Override
                public void removeAttribute(String name) {
                    session.removeAttribute(name);
                }

                @Override
                public void setAttribute(String name, Object value) {
                    session.setAttribute(name, value);
                }
            };
        }
    }
}

