/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.http.OncePerRequestFilter;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionEndListener;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.commons.logging.Log;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public abstract class BaseWebServiceTransactionFilter
extends OncePerRequestFilter {
    protected TransactionHelper transactionHelper;
    protected Log log = this.getLog();

    @Inject
    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    protected abstract boolean applyResponseStateOnRollback();

    @Override
    protected void execute(final HttpServletRequest request, final HttpServletResponse response, final FilterChain chain) throws IOException, ServletException {
        try {
            this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    BaseWebServiceTransactionFilter.this.prepareDebugLog();
                    try {
                        BaseWebServiceTransactionFilter.this.onBeforeRunInTransaction(request, response);
                        BaseWebServiceTransactionFilter.this.doRunInTransaction(request, response, chain, status);
                    }
                    catch (Throwable t) {
                        try {
                            BaseWebServiceTransactionFilter.this.onError(request, response, t);
                        }
                        catch (IOException e) {
                            throw new NestableRuntimeException((Throwable)e);
                        }
                    }
                    finally {
                        try {
                            BaseWebServiceTransactionFilter.this.onTransactionEnd(request, response);
                        }
                        catch (IOException e) {
                            throw new NestableRuntimeException((Throwable)e);
                        }
                    }
                }
            });
        }
        catch (NestableRuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            throw e;
        }
        finally {
            WebServiceContext.cleanup();
            LoggedUser.cleanup();
        }
    }

    protected abstract Log getLog();

    protected abstract String getServiceName();

    protected abstract boolean handleSilencedErrors();

    protected void onBeforeRunInTransaction(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    protected void onError(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException {
    }

    protected void onTransactionEnd(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    /*
     * Exception decompiling
     */
    private void doRunInTransaction(HttpServletRequest request, HttpServletResponse servletResponse, FilterChain chain, TransactionStatus status) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CondenseConditionals.condenseConditionals(CondenseConditionals.java:59)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.condenseConditionals(Op03Rewriters.java:68)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:639)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void prepareDebugLog() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Running " + this.getServiceName() + " in a new transaction"));
            CurrentTransactionData.addTransactionEndListener(new TransactionEndListener(){

                @Override
                protected void onTransactionEnd(boolean commit) {
                    if (commit) {
                        BaseWebServiceTransactionFilter.this.log.debug((Object)("Committed " + BaseWebServiceTransactionFilter.this.getServiceName() + " transaction"));
                    } else {
                        BaseWebServiceTransactionFilter.this.log.debug((Object)("Rolled back " + BaseWebServiceTransactionFilter.this.getServiceName() + " transaction"));
                    }
                }
            });
        }
    }
}

