/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.http.OncePerRequestFilter;
import nl.strohalm.cyclos.struts.CyclosRequestProcessor;
import nl.strohalm.cyclos.utils.ActionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class JspTransactionFilter
extends OncePerRequestFilter {
    private static final Log LOG = LogFactory.getLog(JspTransactionFilter.class);
    private ActionHelper actionHelper;
    private TransactionTemplate transactionTemplate;

    @Inject
    public void setActionHelper(ActionHelper actionHelper) {
        this.actionHelper = actionHelper;
    }

    @Inject
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setReadOnly(true);
    }

    @Override
    protected void execute(final HttpServletRequest request, final HttpServletResponse response, final FilterChain chain) throws IOException, ServletException {
        CyclosRequestProcessor.ExecutionResult result = (CyclosRequestProcessor.ExecutionResult)request.getAttribute("cyclos.executionResult");
        if (result != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(request.getRequestURI() + ": Not opening a new readonly transaction for JSP because CyclosRequestProcessor is managing transactions"));
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            request.setAttribute("cyclos.noTransactionManagement", (Object)true);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(request.getRequestURI() + ": Opening a new readonly transaction for JSP"));
                }
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        try {
                            chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        }
                        catch (Exception e) {
                            JspTransactionFilter.this.actionHelper.generateLog(request, JspTransactionFilter.this.config.getServletContext(), e);
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                ActionHelper.throwException(e.getCause());
            }
        }
    }
}

