/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.util.Collection;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.initializations.LocalWebInitialization;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.services.application.ApplicationService;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionEndListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LifecycleListener
implements ServletContextListener,
HttpSessionListener {
    private static final Log LOG = LogFactory.getLog(LifecycleListener.class);
    private AccessService accessService;
    private TransactionHelper transactionHelper;
    private SettingsService settingsService;
    private ApplicationService applicationService;

    public void contextDestroyed(final ServletContextEvent event) {
        LoggedUser.runAsSystem(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    LocalSettings settings;
                    ServletContext context = event.getServletContext();
                    LocalSettings localSettings = settings = LifecycleListener.this.settingsService == null ? null : LifecycleListener.this.settingsService.getLocalSettings();
                    if (LifecycleListener.this.applicationService != null) {
                        LifecycleListener.this.applicationService.shutdown();
                    }
                    String applicationName = settings == null ? null : settings.getApplicationName();
                    context.log(applicationName == null ? "Cyclos" : applicationName + " destroyed");
                    System.gc();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Error on LifecycleListener.contextDestroyed()", e);
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }

    public void contextInitialized(final ServletContextEvent event) {
        LoggedUser.runAsSystem(new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    ServletContext context = event.getServletContext();
                    WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
                    SpringHelper.injectBeans((BeanFactory)applicationContext, (Object)LifecycleListener.this);
                    LifecycleListener.this.applicationService.initialize();
                    context.setAttribute("systemOnline", (Object)LifecycleListener.this.applicationService.isOnline());
                    context.setAttribute("cyclosVersion", (Object)LifecycleListener.this.applicationService.getCyclosVersion());
                    Collection initializations = applicationContext.getBeansOfType(LocalWebInitialization.class).values();
                    LifecycleListener.this.runAll(initializations);
                    LocalSettings settings = LifecycleListener.this.settingsService.getLocalSettings();
                    context.log(settings.getApplicationName() + " initialized");
                    System.gc();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Error on LifecycleListener.contextInitialized()", e);
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        String sessionId;
        HttpSession session = event.getSession();
        String string = sessionId = session == null ? null : session.getId();
        if (sessionId == null) {
            return;
        }
        if (this.transactionHelper.hasActiveTransaction()) {
            CurrentTransactionData.addTransactionEndListener(new TransactionEndListener(){

                @Override
                protected void onTransactionEnd(boolean commit) {
                    LifecycleListener.this.doLogout(sessionId);
                }
            });
        } else {
            this.doLogout(sessionId);
        }
    }

    @Inject
    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    @Inject
    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    @Inject
    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    @Inject
    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    private void doLogout(final String sessionId) {
        this.transactionHelper.runInNewTransaction(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    LifecycleListener.this.accessService.logout(sessionId);
                }
                catch (NotConnectedException e) {
                }
                catch (RuntimeException e) {
                    LOG.warn((Object)"Error logging out member on session destroy", (Throwable)e);
                    status.setRollbackOnly();
                }
            }
        });
    }

    private void run(final LocalWebInitialization initialization) {
        LOG.debug((Object)String.format("Running web initialization (%s)...", initialization.getName()));
        this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                try {
                    initialization.initialize();
                }
                catch (RuntimeException e) {
                    LOG.error((Object)String.format("Error running web initialization: %s", initialization.getName()), (Throwable)e);
                    throw e;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAll(Collection<LocalWebInitialization> initializations) {
        try {
            for (LocalWebInitialization initialization : initializations) {
                this.run(initialization);
            }
        }
        finally {
            CurrentTransactionData.cleanup();
        }
    }
}

