/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.entities.access.Session;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.http.OncePerRequestFilter;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LoggedUserFilter
extends OncePerRequestFilter {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private AccessService accessService;
    private TransactionHelper transactionHelper;

    @Override
    public void destroy() {
        super.destroy();
        this.attributes.clear();
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        ServletContext servletContext = config.getServletContext();
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        this.attributes.put("servletContext", servletContext);
        this.attributes.put("applicationContext", webApplicationContext);
    }

    @Inject
    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    @Inject
    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession httpSession = request.getSession(false);
        Long userId = (Long)(httpSession == null ? null : httpSession.getAttribute("loggedUserId"));
        if (userId == null) {
            LoggedUser.cleanup();
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            User user;
            try {
                user = this.findLoggedUser(httpSession.getId());
                request.setAttribute("loggedUser", (Object)user);
                request.setAttribute("loggedElement", (Object)user.getElement());
            }
            catch (NotConnectedException e) {
                httpSession.invalidate();
                if (RequestHelper.isAjax(request)) {
                    response.sendError(401);
                    return;
                }
                response.sendRedirect(request.getContextPath() + "/");
                return;
            }
            try {
                LoggedUser.init(user, request.getRemoteAddr(), this.attributes);
                LoggedUser.setAttribute("request", request);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                LoggedUser.cleanup();
            }
        }
    }

    private User findLoggedUser(final String sessionId) {
        return this.transactionHelper.runInCurrentThread(new TransactionCallback<User>(){

            public User doInTransaction(TransactionStatus status) {
                Session session = LoggedUserFilter.this.accessService.checkSession(sessionId);
                return session.getUser();
            }
        });
    }
}

