/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.http.OncePerRequestFilter;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.MessageHelper;
import org.apache.commons.lang.StringUtils;

public class RequestProcessingFilter
extends OncePerRequestFilter {
    private SettingsService settingsService;
    private MessageHelper messageHelper;

    @Inject
    public void setMessageHelper(MessageHelper messageHelper) {
        this.messageHelper = messageHelper;
    }

    @Inject
    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        AccessSettings accessSettings = this.settingsService.getAccessSettings();
        request.setAttribute("localSettings", (Object)localSettings);
        request.setAttribute("accessSettings", (Object)accessSettings);
        request.setAttribute("datePattern", (Object)this.messageHelper.getDatePatternDescription(localSettings.getDatePattern()));
        request.setAttribute("timePattern", (Object)this.messageHelper.getTimePatternDescription(localSettings.getTimePattern()));
        String requestEncoding = request.getCharacterEncoding();
        if (StringUtils.isEmpty((String)requestEncoding)) {
            request.setCharacterEncoding(localSettings.getCharset());
        }
        response.setCharacterEncoding(localSettings.getCharset());
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

