/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.http.AttributeHolder;
import nl.strohalm.cyclos.http.Resettable;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public class ResettableAttributeHolder
implements AttributeHolder,
Resettable {
    private AttributeHolder holder;
    private Map<String, Object> attributes;
    private List<AttributeOperation> operations;

    public ResettableAttributeHolder(AttributeHolder holder) {
        this.holder = holder;
        this.attributes = new HashMap<String, Object>();
        this.operations = new ArrayList<AttributeOperation>();
        this.resetState();
    }

    @Override
    public void applyState() {
        for (AttributeOperation operation : this.operations) {
            operation.apply(this.holder);
        }
        this.operations.clear();
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    @Override
    public void removeAttribute(String name) {
        this.operations.add(AttributeOperation.remove(name));
        this.attributes.remove(name);
    }

    @Override
    public void resetState() {
        this.attributes.clear();
        this.operations.clear();
        Enumeration<String> attributeNames = this.holder.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String key = attributeNames.nextElement();
            this.attributes.put(key, this.holder.getAttribute(key));
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.operations.add(AttributeOperation.set(name, value));
        this.attributes.put(name, value);
    }

    private static abstract class AttributeOperation {
        private AttributeOperation() {
        }

        private static AttributeOperation remove(final String name) {
            return new AttributeOperation(){

                @Override
                public void apply(AttributeHolder holder) {
                    holder.removeAttribute(name);
                }
            };
        }

        private static AttributeOperation set(final String name, final Object value) {
            return new AttributeOperation(){

                @Override
                public void apply(AttributeHolder holder) {
                    holder.setAttribute(name, value);
                }
            };
        }

        public abstract void apply(AttributeHolder var1);
    }
}

