/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.http.AttributeHolder;
import nl.strohalm.cyclos.http.Resettable;
import nl.strohalm.cyclos.http.ResettableAttributeHolder;
import nl.strohalm.cyclos.http.ResettableHttpSession;

public class ResettableHttpServletRequest
extends HttpServletRequestWrapper
implements AttributeHolder,
Resettable {
    private ResettableAttributeHolder attributes;
    private ResettableHttpSession session;

    public ResettableHttpServletRequest(HttpServletRequest request) {
        super(request);
        this.attributes = new ResettableAttributeHolder(AttributeHolder.Factory.request(request));
    }

    @Override
    public void applyState() {
        this.attributes.applyState();
        if (this.session != null) {
            this.session.applyState();
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    public HttpSession getSession() {
        if (this.session != null) {
            return this.session;
        }
        HttpSession original = super.getSession();
        this.session = new ResettableHttpSession(this, original);
        return this.session;
    }

    public HttpSession getSession(boolean create) {
        if (this.session != null) {
            return this.session;
        }
        HttpSession original = super.getSession(create);
        if (original != null) {
            this.session = new ResettableHttpSession(this, original);
        }
        return this.session;
    }

    public void invalidateSession() {
        this.session = null;
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.removeAttribute(name);
    }

    @Override
    public void resetState() {
        this.attributes.resetState();
        if (this.session != null) {
            this.session.resetState();
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.setAttribute(name, value);
    }
}

