/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.http.Resettable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;

public class ResettableHttpServletResponse
implements HttpServletResponse,
Resettable {
    private HttpServletResponse wrapped;
    private List<ResponseOperation> operations;
    private Locale locale;
    private int bufferSize;
    private String contentType;
    private String charset;
    private PrintWriter writer;
    private OutputStream outputStream;
    private ServletOutputStream servletOutputStream;
    private File contents;
    private Set<String> headerNames;
    private Integer status;
    private boolean stateApplied;

    public ResettableHttpServletResponse(HttpServletResponse response) {
        this.wrapped = response;
        this.operations = new ArrayList<ResponseOperation>();
        this.headerNames = new HashSet<String>();
        this.resetState();
    }

    public void addCookie(final Cookie cookie) {
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.addCookie(cookie);
            }
        });
    }

    public void addDateHeader(final String name, final long date) {
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.addDateHeader(name, date);
            }
        });
    }

    public void addHeader(final String name, final String value) {
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.addHeader(name, value);
            }
        });
    }

    public void addIntHeader(final String name, final int value) {
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.addIntHeader(name, value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyState() {
        try {
            for (ResponseOperation operation : this.operations) {
                operation.apply();
            }
            if (this.outputStream != null) {
                try {
                    this.outputStream.flush();
                    IOUtils.copy((InputStream)new FileInputStream(this.contents), (OutputStream)this.wrapped.getOutputStream());
                }
                catch (Exception e) {
                    throw new NestableRuntimeException((Throwable)e);
                }
            }
            if (this.writer != null) {
                try {
                    this.writer.flush();
                    IOUtils.copy((Reader)new FileReader(this.contents), (Writer)this.wrapped.getWriter());
                }
                catch (Exception e) {
                    throw new NestableRuntimeException((Throwable)e);
                }
            }
            this.stateApplied = true;
        }
        finally {
            this.reset();
        }
    }

    public boolean containsHeader(String name) {
        return this.headerNames.contains(name);
    }

    public String encodeRedirectUrl(String url) {
        return this.wrapped.encodeRedirectUrl(url);
    }

    public String encodeRedirectURL(String url) {
        return this.wrapped.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.wrapped.encodeUrl(url);
    }

    public String encodeURL(String url) {
        return this.wrapped.encodeURL(url);
    }

    public void flushBuffer() throws IOException {
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCharacterEncoding() {
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() was already invoked in this response");
        }
        if (this.servletOutputStream == null) {
            this.contents = File.createTempFile("cyclos_", "_response");
            this.outputStream = new FileOutputStream(this.contents);
            this.servletOutputStream = new ServletOutputStream(){

                public void close() throws IOException {
                    ResettableHttpServletResponse.this.outputStream.close();
                }

                public void flush() throws IOException {
                    ResettableHttpServletResponse.this.outputStream.flush();
                }

                public void write(byte[] b) throws IOException {
                    ResettableHttpServletResponse.this.outputStream.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    ResettableHttpServletResponse.this.outputStream.write(b, off, len);
                }

                public void write(int b) throws IOException {
                    ResettableHttpServletResponse.this.outputStream.write(b);
                }
            };
        }
        return this.servletOutputStream;
    }

    public Integer getStatus() {
        return this.status;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("getOutputStream() was already invoked");
        }
        if (this.writer == null) {
            this.contents = File.createTempFile("cyclos_", "_response");
            this.writer = new PrintWriter(this.contents);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        if (!this.stateApplied) {
            return false;
        }
        return this.wrapped.isCommitted();
    }

    public void reset() {
        this.resetState();
    }

    public void resetBuffer() {
        IOUtils.closeQuietly((OutputStream)this.outputStream);
        IOUtils.closeQuietly((Writer)this.writer);
        this.outputStream = null;
        this.servletOutputStream = null;
        this.writer = null;
        if (this.contents != null) {
            this.contents.delete();
            this.contents = null;
        }
    }

    @Override
    public void resetState() {
        this.status = null;
        this.operations.clear();
        this.headerNames.clear();
        this.charset = this.wrapped.getCharacterEncoding();
        this.bufferSize = this.wrapped.getBufferSize();
        this.contentType = this.wrapped.getContentType();
        this.locale = this.wrapped.getLocale();
        this.resetBuffer();
    }

    public void sendError(final int sc) {
        this.status = sc;
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                try {
                    ResettableHttpServletResponse.this.wrapped.sendError(sc);
                }
                catch (IOException e) {
                    throw new NestableRuntimeException((Throwable)e);
                }
            }
        });
    }

    public void sendError(final int sc, final String msg) throws IOException {
        this.status = sc;
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                try {
                    ResettableHttpServletResponse.this.wrapped.sendError(sc, msg);
                }
                catch (IOException e) {
                    throw new NestableRuntimeException((Throwable)e);
                }
            }
        });
    }

    public void sendRedirect(final String location) throws IOException {
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                try {
                    ResettableHttpServletResponse.this.wrapped.sendRedirect(location);
                }
                catch (IOException e) {
                    throw new NestableRuntimeException((Throwable)e);
                }
            }
        });
    }

    public void setBufferSize(final int bufferSize) {
        this.bufferSize = bufferSize;
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.setBufferSize(bufferSize);
            }
        });
    }

    public void setCharacterEncoding(final String charset) {
        this.charset = charset;
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.setCharacterEncoding(charset);
            }
        });
    }

    public void setContentLength(final int len) {
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.setContentLength(len);
            }
        });
    }

    public void setContentType(final String contentType) {
        this.contentType = contentType;
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.setContentType(contentType);
            }
        });
    }

    public void setDateHeader(final String name, final long date) {
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.setDateHeader(name, date);
            }
        });
    }

    public void setHeader(final String name, final String value) {
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.setHeader(name, value);
            }
        });
    }

    public void setIntHeader(final String name, final int value) {
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.setIntHeader(name, value);
            }
        });
    }

    public void setLocale(final Locale locale) {
        this.locale = locale;
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.setLocale(locale);
            }
        });
    }

    public void setStatus(final int sc) {
        this.status = sc;
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.setStatus(sc);
            }
        });
    }

    public void setStatus(final int sc, final String sm) {
        this.status = sc;
        this.operations.add(new ResponseOperation(){

            @Override
            public void apply() {
                ResettableHttpServletResponse.this.wrapped.setStatus(sc, sm);
            }
        });
    }

    private static interface ResponseOperation {
        public void apply();
    }
}

