/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.http.BaseWebServiceTransactionFilter;
import nl.strohalm.cyclos.http.StringBodyRequest;
import nl.strohalm.cyclos.services.application.ApplicationService;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.logging.LoggingHandler;
import nl.strohalm.cyclos.utils.logging.RestLogDTO;
import nl.strohalm.cyclos.webservices.WebServiceContext;
import nl.strohalm.cyclos.webservices.model.ServerErrorVO;
import nl.strohalm.cyclos.webservices.rest.RestHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.springframework.http.HttpStatus;

public class RestFilter
extends BaseWebServiceTransactionFilter {
    private static final Log LOG = LogFactory.getLog(RestFilter.class);
    private ApplicationService applicationService;
    private LoggingHandler loggingHandler;
    private boolean restDisabled;

    @Inject
    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    @Inject
    public void setCyclosProperties(Properties properties) {
        String disabled = properties.getProperty("cyclos.disableRestServices", "false");
        this.restDisabled = Boolean.parseBoolean(disabled);
    }

    @Inject
    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    @Override
    protected boolean applyResponseStateOnRollback() {
        return false;
    }

    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.restDisabled) {
            response.sendError(404);
            return;
        }
        if (!this.applicationService.isOnline()) {
            response.sendError(503);
            return;
        }
        response.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
        if (Boolean.TRUE.equals(this.getServletContext().getAttribute("cyclos.httpEnabled")) && !"https".equalsIgnoreCase(request.getProtocol())) {
            response.sendError(HttpStatus.UPGRADE_REQUIRED.value(), HttpStatus.UPGRADE_REQUIRED.getReasonPhrase());
            response.addHeader("Upgrade", "TLS/1.0, HTTP/1.1");
            response.addHeader("Connection", "Upgrade");
            return;
        }
        boolean logParameters = this.loggingHandler.isRestParametersLogEnabled();
        super.execute((HttpServletRequest)(logParameters ? new StringBodyRequest(request) : request), response, chain);
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    @Override
    protected String getServiceName() {
        return "REST web service";
    }

    @Override
    protected boolean handleSilencedErrors() {
        return true;
    }

    @Override
    protected void onBeforeRunInTransaction(HttpServletRequest request, HttpServletResponse response) {
        WebServiceContext.set((Member)null, this.getServletContext(), request, response);
    }

    @Override
    protected void onError(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException {
        this.log(request, t);
        LOG.error((Object)"Error on REST call", t);
        Pair<ServerErrorVO, Integer> error = RestHelper.resolveError(t);
        ServerErrorVO vo = error.getFirst();
        JSONObject json = new JSONObject();
        if (StringUtils.isNotEmpty((String)vo.getErrorCode())) {
            json.put((Object)"errorCode", (Object)vo.getErrorCode());
        }
        if (StringUtils.isNotEmpty((String)vo.getErrorDetails())) {
            json.put((Object)"errorDetails", (Object)vo.getErrorDetails());
        }
        response.setStatus(error.getSecond().intValue());
        response.setContentType("application/json");
        json.writeJSONString((Writer)response.getWriter());
        response.flushBuffer();
    }

    @Override
    protected void onTransactionEnd(HttpServletRequest request, HttpServletResponse response) {
        this.log(request, null);
    }

    private RestLogDTO buildLogDTO(HttpServletRequest request, Throwable error) {
        String body;
        if (request instanceof StringBodyRequest) {
            try {
                body = ((StringBodyRequest)request).getBody();
            }
            catch (Exception e) {
                body = "<Error obtaining request body: " + e.toString() + ">";
            }
        } else {
            body = null;
        }
        RestLogDTO dto = new RestLogDTO();
        dto.setRemoteAddress(request.getRemoteAddr());
        dto.setMember(LoggedUser.hasUser() ? LoggedUser.member() : null);
        dto.setMethod(request.getMethod());
        dto.setUri(request.getRequestURI());
        dto.setQueryString(request.getQueryString());
        dto.setRequestBody(body);
        return dto;
    }

    private void log(HttpServletRequest request, Throwable error) {
        RestLogDTO dto = this.buildLogDTO(request, error);
        this.loggingHandler.traceRest(dto);
    }
}

