/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import nl.strohalm.cyclos.utils.StringHelper;

public class SanitizedHttpServletRequest
extends HttpServletRequestWrapper {
    public SanitizedHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String name) {
        return StringHelper.removeMarkupTags(super.getParameter(name));
    }

    public Map getParameterMap() {
        Map map = super.getParameterMap();
        HashMap sanitizedMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            sanitizedMap.put(entry.getKey(), this.sanitize((String[])entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    public String[] getParameterValues(String name) {
        return this.sanitize(super.getParameterValues(name));
    }

    private String[] sanitize(String[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = StringHelper.removeMarkupTags(values[i]);
            }
        }
        return values;
    }
}

