/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.http.OncePerRequestFilter;
import nl.strohalm.cyclos.http.SanitizedHttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class SanitizerFilter
extends OncePerRequestFilter {
    private Pattern exclusionPattern = null;

    @Override
    public void destroy() {
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        String excluded = config.getInitParameter("exclusionPattern");
        if (StringUtils.isNotEmpty((String)excluded) && StringUtils.isNotEmpty((String)(excluded = StringUtils.deleteWhitespace((String)StringUtils.replace((String)excluded, (String)"\n", (String)"|"))))) {
            this.exclusionPattern = Pattern.compile(excluded);
        }
    }

    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object httpRequest = request;
        if (this.mustSanitize((HttpServletRequest)httpRequest)) {
            httpRequest = new SanitizedHttpServletRequest(request);
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)response);
    }

    private boolean mustSanitize(HttpServletRequest request) {
        return this.exclusionPattern != null && request.getPathInfo() != null && !this.exclusionPattern.matcher(request.getPathInfo()).matches();
    }
}

