/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class StringBodyRequest
extends HttpServletRequestWrapper {
    private String body;
    private Boolean reader;

    public StringBodyRequest(HttpServletRequest request) {
        super(request);
    }

    public String getBody() throws IOException {
        this.initBodyFromReaderIfNeeded();
        return this.body;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (Boolean.TRUE.equals(this.reader)) {
            throw new IllegalStateException("The getWriter() method was already invoked for this request");
        }
        this.reader = false;
        String characterEncoding = this.getCharacterEncoding();
        if (characterEncoding == null) {
            characterEncoding = "UTF-8";
        }
        if (this.body == null) {
            this.readBody(new InputStreamReader((InputStream)super.getInputStream(), characterEncoding));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.body.getBytes(characterEncoding));
        return new DelegatingServletInputStream(in);
    }

    public BufferedReader getReader() throws IOException {
        if (Boolean.FALSE.equals(this.reader)) {
            throw new IllegalStateException("The getInputStream() method was already invoked for this request");
        }
        this.reader = true;
        this.initBodyFromReaderIfNeeded();
        return new BufferedReader(new StringReader(this.body));
    }

    private void initBodyFromReaderIfNeeded() throws IOException {
        if (this.body == null) {
            this.readBody(super.getReader());
        }
    }

    private void readBody(Reader in) throws IOException {
        this.body = IOUtils.toString((Reader)in);
    }

    private static class DelegatingServletInputStream
    extends ServletInputStream {
        private InputStream in;

        private DelegatingServletInputStream(InputStream in) {
            this.in = in;
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public void close() throws IOException {
            this.in.close();
        }

        public void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public int read(byte[] b) throws IOException {
            return this.in.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        public void reset() throws IOException {
            this.in.reset();
        }

        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }
    }
}

