/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.initializations;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.entities.alerts.SystemAlert;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFileQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.initializations.LocalInitialization;
import nl.strohalm.cyclos.services.customization.CustomizedFileServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.ServletContextAware;

public class CustomizedFileInitialization
implements LocalInitialization,
ServletContextAware {
    private static final Log LOG = LogFactory.getLog(CustomizedFileInitialization.class);
    private CustomizedFileServiceLocal customizedFileService;
    private CustomizationHelper customizationHelper;
    private ServletContext servletContext;
    private SettingsServiceLocal settingsServiceLocal;

    @Override
    public String getName() {
        return "Customized files";
    }

    @Override
    public void initialize() {
        File customizedStylesDir = new File(this.servletContext.getRealPath(this.customizationHelper.customizedPathFor(CustomizedFile.Type.STYLE)));
        for (File css : customizedStylesDir.listFiles((FilenameFilter)new SuffixFileFilter(".css"))) {
            css.delete();
        }
        LocalSettings localSettings = this.settingsServiceLocal.getLocalSettings();
        CustomizedFileQuery query = new CustomizedFileQuery();
        query.fetch(CustomizedFile.Relationships.GROUP);
        query.setAll(true);
        List<CustomizedFile> files = this.customizedFileService.search(query);
        for (CustomizedFile customizedFile : files) {
            CustomizedFile.Type type = customizedFile.getType();
            String name = customizedFile.getName();
            File physicalFile = this.customizationHelper.customizedFileOf(customizedFile);
            File originalFile = this.customizationHelper.originalFileOf(type, name);
            if (!originalFile.exists()) {
                this.customizedFileService.stopCustomizing(customizedFile);
                continue;
            }
            try {
                long lastModified;
                if (type != CustomizedFile.Type.STYLE) {
                    boolean newContentsChanged;
                    boolean contentsChanged;
                    boolean wasConflict = customizedFile.isConflict();
                    String originalFileContents = null;
                    if (originalFile.exists() && (originalFileContents = FileUtils.readFileToString((File)originalFile)).length() == 0) {
                        originalFileContents = null;
                    }
                    if (type == CustomizedFile.Type.APPLICATION_PAGE) {
                        contentsChanged = !StringUtils.trimToEmpty((String)originalFileContents).equals(StringUtils.trimToEmpty((String)customizedFile.getOriginalContents())) && !StringUtils.trimToEmpty((String)originalFileContents).equals(StringUtils.trimToEmpty((String)customizedFile.getContents()));
                        newContentsChanged = contentsChanged && !StringUtils.trimToEmpty((String)originalFileContents).equals(StringUtils.trimToEmpty((String)customizedFile.getNewContents()));
                    } else {
                        contentsChanged = !StringUtils.trimToEmpty((String)originalFileContents).equals(StringUtils.trimToEmpty((String)customizedFile.getOriginalContents()));
                        boolean bl = newContentsChanged = !StringUtils.trimToEmpty((String)originalFileContents).equals(StringUtils.trimToEmpty((String)customizedFile.getNewContents()));
                    }
                    if (!wasConflict && contentsChanged) {
                        customizedFile.setNewContents(originalFileContents);
                        this.customizedFileService.save(customizedFile);
                        if (customizedFile.getGroup() == null && customizedFile.getGroupFilter() == null) {
                            SystemAlert.Alerts alertType = null;
                            switch (type) {
                                case APPLICATION_PAGE: {
                                    alertType = SystemAlert.Alerts.NEW_VERSION_OF_APPLICATION_PAGE;
                                    break;
                                }
                                case HELP: {
                                    alertType = SystemAlert.Alerts.NEW_VERSION_OF_HELP_FILE;
                                    break;
                                }
                                case STATIC_FILE: {
                                    alertType = SystemAlert.Alerts.NEW_VERSION_OF_STATIC_FILE;
                                }
                            }
                            this.customizedFileService.notifyNewVersion(alertType, customizedFile);
                        }
                    } else if (wasConflict && newContentsChanged) {
                        customizedFile.setNewContents(originalFileContents);
                        this.customizedFileService.save(customizedFile);
                    }
                }
                long l = lastModified = customizedFile.getLastModified() == null ? System.currentTimeMillis() : customizedFile.getLastModified().getTimeInMillis();
                if (physicalFile.exists() && physicalFile.lastModified() == lastModified) continue;
                physicalFile.getParentFile().mkdirs();
                FileUtils.writeStringToFile((File)physicalFile, (String)customizedFile.getContents(), (String)localSettings.getCharset());
                physicalFile.setLastModified(lastModified);
            }
            catch (IOException e) {
                LOG.warn((Object)("Error handling customized file: " + physicalFile.getAbsolutePath()), (Throwable)e);
            }
        }
        String virtualPath = this.customizationHelper.originalPathFor(CustomizedFile.Type.STYLE);
        File originalDir = new File(this.servletContext.getRealPath(virtualPath));
        if (originalDir == null || originalDir.listFiles() == null) {
            LOG.error((Object)("Error copying any style sheet file due to path problems. Images may not be locatable now. Unresolvable path: " + virtualPath));
            return;
        }
        for (File original : originalDir.listFiles()) {
            File customized = new File(customizedStylesDir, original.getName());
            if (customized.exists()) continue;
            try {
                FileUtils.copyFile((File)original, (File)customized);
            }
            catch (IOException e) {
                LOG.warn((Object)("Error copying style sheet file: " + customized.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    public void setCustomizedFileServiceLocal(CustomizedFileServiceLocal customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsServiceLocal) {
        this.settingsServiceLocal = settingsServiceLocal;
    }
}

